/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.common;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.databind.DeserializationContext;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import io.opentelemetry.testing.internal.jackson.databind.JsonNode;
import io.opentelemetry.testing.internal.jackson.databind.deser.std.StdDeserializer;
import io.opentelemetry.testing.internal.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

abstract class AbstractHttpHeadersJsonDeserializer<T extends HttpHeaders>
extends StdDeserializer<T> {
    private static final long serialVersionUID = 6308506823069217145L;

    AbstractHttpHeadersJsonDeserializer(Class<T> type) {
        super(type);
    }

    @Override
    @Nullable
    public final T deserialize(JsonParser p, DeserializationContext ctx) throws IOException {
        JsonNode tree = (JsonNode)p.getCodec().readTree(p);
        if (!tree.isObject()) {
            ctx.reportInputMismatch(HttpHeaders.class, "HTTP headers must be an object.", new Object[0]);
            return null;
        }
        ObjectNode obj = (ObjectNode)tree;
        HttpHeadersBuilder builder = this.newBuilder();
        Iterator<Map.Entry<String, JsonNode>> i = obj.fields();
        while (i.hasNext()) {
            Map.Entry<String, JsonNode> e = i.next();
            AsciiString name = HttpHeaderNames.of(e.getKey());
            JsonNode values = e.getValue();
            if (!values.isArray()) {
                this.addHeader(ctx, builder, name, values);
                continue;
            }
            int numValues = values.size();
            for (int j = 0; j < numValues; ++j) {
                JsonNode v = values.get(j);
                this.addHeader(ctx, builder, name, v);
            }
        }
        try {
            HttpHeaders headers = builder.build();
            return (T)headers;
        }
        catch (IllegalStateException e) {
            return (T)((HttpHeaders)ctx.reportInputMismatch(this.handledType(), MoreObjects.firstNonNull(e.getMessage(), "Required headers are missing."), new Object[0]));
        }
    }

    private void addHeader(DeserializationContext ctx, HttpHeadersBuilder builder, AsciiString name, JsonNode valueNode) throws JsonMappingException {
        if (valueNode.isTextual()) {
            builder.add((CharSequence)name, valueNode.asText());
        } else {
            ctx.reportInputMismatch(this.handledType(), "HTTP header '%s' contains %s (%s); only strings are allowed.", new Object[]{name, valueNode.getNodeType(), valueNode});
        }
    }

    abstract HttpHeadersBuilder newBuilder();
}

