/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.websocket;

import io.opentelemetry.testing.internal.armeria.client.AbstractWebClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.ClientFactory;
import io.opentelemetry.testing.internal.armeria.client.ClientOption;
import io.opentelemetry.testing.internal.armeria.client.ClientOptionValue;
import io.opentelemetry.testing.internal.armeria.client.ClientOptions;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.Clients;
import io.opentelemetry.testing.internal.armeria.client.DecoratingHttpClientFunction;
import io.opentelemetry.testing.internal.armeria.client.DecoratingRpcClientFunction;
import io.opentelemetry.testing.internal.armeria.client.Endpoint;
import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.HttpPreprocessor;
import io.opentelemetry.testing.internal.armeria.client.ResponseTimeoutMode;
import io.opentelemetry.testing.internal.armeria.client.RpcClient;
import io.opentelemetry.testing.internal.armeria.client.RpcPreprocessor;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.endpoint.EndpointGroup;
import io.opentelemetry.testing.internal.armeria.client.redirect.RedirectConfig;
import io.opentelemetry.testing.internal.armeria.client.websocket.DefaultWebSocketClient;
import io.opentelemetry.testing.internal.armeria.client.websocket.WebSocketClient;
import io.opentelemetry.testing.internal.armeria.common.RequestId;
import io.opentelemetry.testing.internal.armeria.common.Scheme;
import io.opentelemetry.testing.internal.armeria.common.SerializationFormat;
import io.opentelemetry.testing.internal.armeria.common.SessionProtocol;
import io.opentelemetry.testing.internal.armeria.common.SuccessFunction;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.common.auth.AuthToken;
import io.opentelemetry.testing.internal.armeria.common.auth.BasicToken;
import io.opentelemetry.testing.internal.armeria.common.auth.OAuth1aToken;
import io.opentelemetry.testing.internal.armeria.common.auth.OAuth2Token;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

@UnstableApi
public final class WebSocketClientBuilder
extends AbstractWebClientBuilder {
    static final int DEFAULT_MAX_FRAME_PAYLOAD_LENGTH = 65535;
    private int maxFramePayloadLength = 65535;
    private boolean allowMaskMismatch;
    private List<String> subprotocols = ImmutableList.of();
    private boolean aggregateContinuation;

    WebSocketClientBuilder(URI uri) {
        super(WebSocketClientBuilder.validateUri(Objects.requireNonNull(uri, "uri")), null, null, null);
        this.setWebSocketDefaultOption();
    }

    WebSocketClientBuilder(Scheme scheme, EndpointGroup endpointGroup, @Nullable String path) {
        super(null, WebSocketClientBuilder.validateScheme(Objects.requireNonNull(scheme, "scheme")), endpointGroup, path);
        this.setWebSocketDefaultOption();
    }

    private static URI validateUri(URI uri) {
        if (Clients.isUndefinedUri(uri)) {
            return uri;
        }
        String givenScheme = Objects.requireNonNull(uri, "uri").getScheme();
        Scheme scheme = WebSocketClientBuilder.validateScheme(givenScheme);
        if (scheme.uriText().equals(givenScheme)) {
            return uri;
        }
        return URI.create(scheme.uriText() + uri.toString().substring(givenScheme.length()));
    }

    private static Scheme validateScheme(String scheme) {
        Scheme parsedScheme = Scheme.tryParse(scheme);
        if (parsedScheme != null) {
            return WebSocketClientBuilder.validateScheme(parsedScheme);
        }
        throw WebSocketClientBuilder.invalidSchemeException(scheme);
    }

    private static Scheme validateScheme(Scheme scheme) {
        SerializationFormat serializationFormat = scheme.serializationFormat();
        if ((serializationFormat == SerializationFormat.WS || serializationFormat == SerializationFormat.NONE) && SessionProtocol.httpAndHttpsValues().contains((Object)scheme.sessionProtocol())) {
            if (serializationFormat == SerializationFormat.WS) {
                return scheme;
            }
            return Scheme.of(SerializationFormat.WS, scheme.sessionProtocol());
        }
        throw WebSocketClientBuilder.invalidSchemeException(scheme.toString());
    }

    private static IllegalArgumentException invalidSchemeException(String scheme) {
        return new IllegalArgumentException(String.format("scheme: %s (expected serialization format: %s or %s, expected session protocol: one of %s)", scheme, SerializationFormat.WS, SerializationFormat.NONE, SessionProtocol.httpAndHttpsValues()));
    }

    private void setWebSocketDefaultOption() {
        this.responseTimeoutMillis(0L);
        this.maxResponseLength(0L);
        this.requestAutoAbortDelayMillis(5000L);
        this.autoFillOriginHeader(true);
        this.contextCustomizer((T ctx) -> ctx.logBuilder().serializationFormat(SerializationFormat.WS));
    }

    public WebSocketClientBuilder maxFramePayloadLength(int maxFramePayloadLength) {
        Preconditions.checkArgument(maxFramePayloadLength > 0, "maxFramePayloadLength: %s (expected: > 0)", maxFramePayloadLength);
        this.maxFramePayloadLength = maxFramePayloadLength;
        return this;
    }

    public WebSocketClientBuilder allowMaskMismatch(boolean allowMaskMismatch) {
        this.allowMaskMismatch = allowMaskMismatch;
        return this;
    }

    public WebSocketClientBuilder subprotocols(String ... subprotocols) {
        return this.subprotocols(ImmutableSet.copyOf(Objects.requireNonNull(subprotocols, "subprotocols")));
    }

    public WebSocketClientBuilder subprotocols(Iterable<String> subprotocols) {
        this.subprotocols = ImmutableList.copyOf(Objects.requireNonNull(subprotocols, "subprotocols"));
        return this;
    }

    public WebSocketClientBuilder aggregateContinuation(boolean aggregateContinuation) {
        this.aggregateContinuation = aggregateContinuation;
        return this;
    }

    public WebSocketClientBuilder autoFillOriginHeader(boolean autoFillOriginHeader) {
        this.option((ClientOption)ClientOptions.AUTO_FILL_ORIGIN_HEADER, (Object)autoFillOriginHeader);
        return this;
    }

    public WebSocketClient build() {
        WebClient webClient = this.buildWebClient();
        return new DefaultWebSocketClient(webClient, this.maxFramePayloadLength, this.allowMaskMismatch, this.subprotocols, this.aggregateContinuation);
    }

    @Override
    @Deprecated
    public WebSocketClientBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        return (WebSocketClientBuilder)super.rpcDecorator((Function)decorator);
    }

    @Override
    @Deprecated
    public WebSocketClientBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        return (WebSocketClientBuilder)super.rpcDecorator(decorator);
    }

    @Override
    public WebSocketClientBuilder options(ClientOptions options) {
        return (WebSocketClientBuilder)super.options(options);
    }

    @Override
    public WebSocketClientBuilder options(ClientOptionValue<?> ... options) {
        return (WebSocketClientBuilder)super.options(options);
    }

    @Override
    public WebSocketClientBuilder options(Iterable<ClientOptionValue<?>> options) {
        return (WebSocketClientBuilder)super.options(options);
    }

    @Override
    public <T> WebSocketClientBuilder option(ClientOption<T> option, T value) {
        return (WebSocketClientBuilder)super.option(option, value);
    }

    @Override
    public <T> WebSocketClientBuilder option(ClientOptionValue<T> optionValue) {
        return (WebSocketClientBuilder)super.option(optionValue);
    }

    @Override
    public WebSocketClientBuilder factory(ClientFactory factory) {
        return (WebSocketClientBuilder)super.factory(factory);
    }

    @Override
    public WebSocketClientBuilder writeTimeout(Duration writeTimeout) {
        return (WebSocketClientBuilder)super.writeTimeout(writeTimeout);
    }

    @Override
    public WebSocketClientBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return (WebSocketClientBuilder)super.writeTimeoutMillis(writeTimeoutMillis);
    }

    @Override
    public WebSocketClientBuilder responseTimeout(Duration responseTimeout) {
        return (WebSocketClientBuilder)super.responseTimeout(responseTimeout);
    }

    @Override
    public WebSocketClientBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return (WebSocketClientBuilder)super.responseTimeoutMillis(responseTimeoutMillis);
    }

    @Override
    public WebSocketClientBuilder maxResponseLength(long maxResponseLength) {
        return (WebSocketClientBuilder)super.maxResponseLength(maxResponseLength);
    }

    @Override
    public WebSocketClientBuilder requestAutoAbortDelay(Duration delay) {
        return (WebSocketClientBuilder)super.requestAutoAbortDelay(delay);
    }

    @Override
    public WebSocketClientBuilder requestAutoAbortDelayMillis(long delayMillis) {
        return (WebSocketClientBuilder)super.requestAutoAbortDelayMillis(delayMillis);
    }

    @Override
    public WebSocketClientBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return (WebSocketClientBuilder)super.requestIdGenerator(requestIdGenerator);
    }

    @Override
    public WebSocketClientBuilder successFunction(SuccessFunction successFunction) {
        return (WebSocketClientBuilder)super.successFunction(successFunction);
    }

    @Override
    public WebSocketClientBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        return (WebSocketClientBuilder)super.endpointRemapper(endpointRemapper);
    }

    @Override
    public WebSocketClientBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return (WebSocketClientBuilder)super.decorator(decorator);
    }

    @Override
    public WebSocketClientBuilder decorator(DecoratingHttpClientFunction decorator) {
        return (WebSocketClientBuilder)super.decorator(decorator);
    }

    @Override
    public WebSocketClientBuilder clearDecorators() {
        return (WebSocketClientBuilder)super.clearDecorators();
    }

    @Override
    public WebSocketClientBuilder addHeader(CharSequence name, Object value) {
        return (WebSocketClientBuilder)super.addHeader(name, value);
    }

    @Override
    public WebSocketClientBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (WebSocketClientBuilder)super.addHeaders(headers);
    }

    @Override
    public WebSocketClientBuilder setHeader(CharSequence name, Object value) {
        return (WebSocketClientBuilder)super.setHeader(name, value);
    }

    @Override
    public WebSocketClientBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (WebSocketClientBuilder)super.setHeaders(headers);
    }

    @Override
    public WebSocketClientBuilder auth(BasicToken token) {
        return (WebSocketClientBuilder)super.auth(token);
    }

    @Override
    public WebSocketClientBuilder auth(OAuth1aToken token) {
        return (WebSocketClientBuilder)super.auth(token);
    }

    @Override
    public WebSocketClientBuilder auth(OAuth2Token token) {
        return (WebSocketClientBuilder)super.auth(token);
    }

    @Override
    public WebSocketClientBuilder auth(AuthToken token) {
        return (WebSocketClientBuilder)super.auth(token);
    }

    @Override
    public WebSocketClientBuilder followRedirects() {
        return (WebSocketClientBuilder)super.followRedirects();
    }

    @Override
    public WebSocketClientBuilder followRedirects(RedirectConfig redirectConfig) {
        return (WebSocketClientBuilder)super.followRedirects(redirectConfig);
    }

    @Override
    public WebSocketClientBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        return (WebSocketClientBuilder)super.contextCustomizer(contextCustomizer);
    }

    @Override
    public WebSocketClientBuilder contextHook(Supplier<? extends AutoCloseable> contextHook) {
        return (WebSocketClientBuilder)super.contextHook(contextHook);
    }

    @Override
    public WebSocketClientBuilder responseTimeoutMode(ResponseTimeoutMode responseTimeoutMode) {
        return (WebSocketClientBuilder)super.responseTimeoutMode(responseTimeoutMode);
    }

    @Override
    @Deprecated
    public WebSocketClientBuilder preprocessor(HttpPreprocessor preprocessor) {
        throw new UnsupportedOperationException("WebSocketClientBuilder does not support preprocessor.");
    }

    @Override
    @Deprecated
    public WebSocketClientBuilder rpcPreprocessor(RpcPreprocessor rpcPreprocessor) {
        return (WebSocketClientBuilder)super.rpcPreprocessor(rpcPreprocessor);
    }
}

