/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.HttpClient;
import io.opentelemetry.testing.internal.armeria.client.retry.AbstractRetryingClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfig;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryConfigMapping;
import io.opentelemetry.testing.internal.armeria.client.retry.RetryingClient;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import java.time.Duration;
import java.util.function.Function;

public final class RetryingClientBuilder
extends AbstractRetryingClientBuilder<HttpResponse> {
    private boolean useRetryAfter;

    RetryingClientBuilder(RetryConfig<HttpResponse> retryConfig) {
        super(retryConfig);
    }

    RetryingClientBuilder(RetryConfigMapping<HttpResponse> mapping) {
        super(mapping);
    }

    public RetryingClientBuilder useRetryAfter(boolean useRetryAfter) {
        this.useRetryAfter = useRetryAfter;
        return this;
    }

    public RetryingClient build(HttpClient delegate) {
        return new RetryingClient(delegate, this.mapping(), this.retryConfig(), this.useRetryAfter);
    }

    public Function<? super HttpClient, RetryingClient> newDecorator() {
        return this::build;
    }

    @Override
    public String toString() {
        return this.toStringHelper().add("useRetryAfter", this.useRetryAfter).toString();
    }

    public RetryingClientBuilder maxTotalAttempts(int maxTotalAttempts) {
        return (RetryingClientBuilder)super.maxTotalAttempts(maxTotalAttempts);
    }

    public RetryingClientBuilder responseTimeoutMillisForEachAttempt(long responseTimeoutMillisForEachAttempt) {
        return (RetryingClientBuilder)super.responseTimeoutMillisForEachAttempt(responseTimeoutMillisForEachAttempt);
    }

    public RetryingClientBuilder responseTimeoutForEachAttempt(Duration responseTimeoutForEachAttempt) {
        return (RetryingClientBuilder)super.responseTimeoutForEachAttempt(responseTimeoutForEachAttempt);
    }
}

