/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.retry;

import io.opentelemetry.testing.internal.armeria.client.retry.AbstractBackoff;
import io.opentelemetry.testing.internal.armeria.client.retry.Backoff;
import io.opentelemetry.testing.internal.armeria.client.retry.BackoffWrapper;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;

final class AttemptLimitingBackoff
extends BackoffWrapper {
    private final int maxAttempts;

    AttemptLimitingBackoff(Backoff backoff, int maxAttempts) {
        super(backoff);
        Preconditions.checkArgument(maxAttempts > 0, "maxAttempts: %s (expected: > 0)", maxAttempts);
        this.maxAttempts = maxAttempts;
    }

    @Override
    public long nextDelayMillis(int numAttemptsSoFar) {
        AbstractBackoff.validateNumAttemptsSoFar(numAttemptsSoFar);
        if (numAttemptsSoFar >= this.maxAttempts) {
            return -1L;
        }
        return super.nextDelayMillis(numAttemptsSoFar);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("delegate", this.unwrap()).add("maxAttempts", this.maxAttempts).toString();
    }
}

