/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.metric;

import io.opentelemetry.testing.internal.armeria.client.Client;
import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.SimpleDecoratingClient;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.metric.MeterIdPrefixFunction;
import io.opentelemetry.testing.internal.armeria.internal.common.metric.RequestMetricSupport;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import java.util.Objects;
import java.util.function.BiPredicate;

abstract class AbstractMetricCollectingClient<I extends Request, O extends Response>
extends SimpleDecoratingClient<I, O> {
    private static final AttributeKey<Boolean> REQUEST_METRICS_SET = AttributeKey.valueOf(AbstractMetricCollectingClient.class, "REQUEST_METRICS_SET");
    private final MeterIdPrefixFunction meterIdPrefixFunction;
    @Nullable
    private final BiPredicate<? super RequestContext, ? super RequestLog> successFunction;
    private final DistributionStatisticConfig distributionStatisticConfig;

    AbstractMetricCollectingClient(Client<I, O> delegate, MeterIdPrefixFunction meterIdPrefixFunction, @Nullable BiPredicate<? super RequestContext, ? super RequestLog> successFunction, DistributionStatisticConfig distributionStatisticConfig) {
        super(delegate);
        this.meterIdPrefixFunction = Objects.requireNonNull(meterIdPrefixFunction, "meterIdPrefixFunction");
        this.successFunction = successFunction;
        this.distributionStatisticConfig = Objects.requireNonNull(distributionStatisticConfig, "distributionStatisticConfig");
    }

    @Override
    public final O execute(ClientRequestContext ctx, I req) throws Exception {
        RequestMetricSupport.setup(ctx, REQUEST_METRICS_SET, this.meterIdPrefixFunction, false, this.successFunction != null ? this.successFunction::test : ctx.options().successFunction(), this.distributionStatisticConfig);
        return ((Client)this.unwrap()).execute(ctx, req);
    }
}

