/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.client.circuitbreaker;

import io.opentelemetry.testing.internal.armeria.client.ClientRequestContext;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerMapping;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRule;
import io.opentelemetry.testing.internal.armeria.client.circuitbreaker.CircuitBreakerRuleWithContent;
import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.Response;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;
import java.util.function.BiFunction;

public abstract class AbstractCircuitBreakerClientBuilder<I extends Request, O extends Response> {
    @Nullable
    private final CircuitBreakerRule rule;
    @Nullable
    private final CircuitBreakerRuleWithContent<O> ruleWithContent;
    private CircuitBreakerClientHandler handler = CircuitBreakerClientHandler.of(CircuitBreakerMapping.ofDefault());
    @Nullable
    private BiFunction<? super ClientRequestContext, ? super I, ? extends O> fallback;

    AbstractCircuitBreakerClientBuilder(CircuitBreakerRule rule) {
        this(Objects.requireNonNull(rule, "rule"), null, null);
    }

    AbstractCircuitBreakerClientBuilder(CircuitBreakerRuleWithContent<O> ruleWithContent) {
        this(null, Objects.requireNonNull(ruleWithContent, "ruleWithContent"), null);
    }

    private AbstractCircuitBreakerClientBuilder(@Nullable CircuitBreakerRule rule, @Nullable CircuitBreakerRuleWithContent<O> ruleWithContent, @Nullable BiFunction<? super ClientRequestContext, I, O> fallback) {
        this.rule = rule;
        this.ruleWithContent = ruleWithContent;
        this.fallback = fallback;
    }

    final CircuitBreakerRule rule() {
        Preconditions.checkState(this.rule != null, "rule is not set.");
        return this.rule;
    }

    final CircuitBreakerRuleWithContent<O> ruleWithContent() {
        Preconditions.checkState(this.ruleWithContent != null, "ruleWithContent is not set.");
        return this.ruleWithContent;
    }

    @UnstableApi
    public AbstractCircuitBreakerClientBuilder<I, O> mapping(CircuitBreakerMapping mapping) {
        this.handler = CircuitBreakerClientHandler.of(Objects.requireNonNull(mapping, "mapping"));
        return this;
    }

    @UnstableApi
    public AbstractCircuitBreakerClientBuilder<I, O> handler(CircuitBreakerClientHandler handler) {
        this.handler = Objects.requireNonNull(handler, "handler");
        return this;
    }

    final CircuitBreakerClientHandler handler() {
        return this.handler;
    }

    @Nullable
    final BiFunction<? super ClientRequestContext, ? super I, ? extends O> fallback() {
        return this.fallback;
    }

    @UnstableApi
    public AbstractCircuitBreakerClientBuilder<I, O> recover(BiFunction<? super ClientRequestContext, ? super I, ? extends O> fallback) {
        Objects.requireNonNull(fallback, "fallback");
        this.fallback = fallback;
        return this;
    }
}

