/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http.impl.nio;

import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpResponse;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpResponseFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.http.config.Http1Config;
import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.nio.DefaultHttpResponseFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.nio.DefaultHttpResponseParser;
import io.opentelemetry.testing.internal.apachehttp.core5.http.message.LazyLaxLineParser;
import io.opentelemetry.testing.internal.apachehttp.core5.http.message.LineParser;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.NHttpMessageParser;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.NHttpMessageParserFactory;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements NHttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final Http1Config http1Config;
    private final HttpResponseFactory<HttpResponse> responseFactory;
    private final LineParser lineParser;

    public DefaultHttpResponseParserFactory(Http1Config http1Config, HttpResponseFactory<HttpResponse> responseFactory, LineParser lineParser) {
        this.http1Config = http1Config != null ? http1Config : Http1Config.DEFAULT;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineParser = lineParser != null ? lineParser : LazyLaxLineParser.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(Http1Config http1Config) {
        this(http1Config, null, null);
    }

    public DefaultHttpResponseParserFactory() {
        this(null);
    }

    @Override
    public NHttpMessageParser<HttpResponse> create() {
        return new DefaultHttpResponseParser<HttpResponse>(this.responseFactory, this.lineParser, this.http1Config);
    }
}

