/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.core5.http.impl.nio;

import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpHost;
import io.opentelemetry.testing.internal.apachehttp.core5.http.URIScheme;
import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.nio.ClientHttp1IOEventHandler;
import io.opentelemetry.testing.internal.apachehttp.core5.http.impl.nio.ClientHttp1StreamDuplexerFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.ssl.TlsStrategy;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.EndpointParameters;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOEventHandler;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.IOEventHandlerFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.ProtocolIOSession;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Timeout;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ClientHttp1IOEventHandlerFactory
implements IOEventHandlerFactory {
    private final ClientHttp1StreamDuplexerFactory streamDuplexerFactory;
    private final TlsStrategy tlsStrategy;
    private final Timeout handshakeTimeout;

    public ClientHttp1IOEventHandlerFactory(ClientHttp1StreamDuplexerFactory streamDuplexerFactory, TlsStrategy tlsStrategy, Timeout handshakeTimeout) {
        this.streamDuplexerFactory = Args.notNull(streamDuplexerFactory, "Stream duplexer factory");
        this.tlsStrategy = tlsStrategy;
        this.handshakeTimeout = handshakeTimeout;
    }

    @Override
    public IOEventHandler createHandler(ProtocolIOSession ioSession, Object attachment) {
        if (attachment instanceof EndpointParameters) {
            EndpointParameters params = (EndpointParameters)attachment;
            if (this.tlsStrategy != null && URIScheme.HTTPS.same(params.getScheme())) {
                HttpHost host = new HttpHost(params.getScheme(), params.getHostName(), params.getPort());
                this.tlsStrategy.upgrade(ioSession, host, ioSession.getLocalAddress(), ioSession.getRemoteAddress(), params.getAttachment(), this.handshakeTimeout);
            }
        }
        return new ClientHttp1IOEventHandler(this.streamDuplexerFactory.create(ioSession));
    }
}

