/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.impl.classic;

import io.opentelemetry.testing.internal.apachehttp.client5.http.HttpRoute;
import io.opentelemetry.testing.internal.apachehttp.client5.http.classic.BackoffManager;
import io.opentelemetry.testing.internal.apachehttp.client5.http.classic.ConnectionBackoffStrategy;
import io.opentelemetry.testing.internal.apachehttp.client5.http.classic.ExecChain;
import io.opentelemetry.testing.internal.apachehttp.client5.http.classic.ExecChainHandler;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Experimental;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ClassicHttpRequest;
import io.opentelemetry.testing.internal.apachehttp.core5.http.ClassicHttpResponse;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpException;
import io.opentelemetry.testing.internal.apachehttp.core5.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.STATELESS)
@Experimental
public final class BackoffStrategyExec
implements ExecChainHandler {
    private final ConnectionBackoffStrategy connectionBackoffStrategy;
    private final BackoffManager backoffManager;

    public BackoffStrategyExec(ConnectionBackoffStrategy connectionBackoffStrategy, BackoffManager backoffManager) {
        Args.notNull(connectionBackoffStrategy, "Connection backoff strategy");
        Args.notNull(backoffManager, "Backoff manager");
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.backoffManager = backoffManager;
    }

    @Override
    public ClassicHttpResponse execute(ClassicHttpRequest request, ExecChain.Scope scope, ExecChain chain) throws IOException, HttpException {
        ClassicHttpResponse response;
        Args.notNull(request, "HTTP request");
        Args.notNull(scope, "Scope");
        HttpRoute route = scope.route;
        try {
            response = chain.proceed(request, scope);
        }
        catch (HttpException | IOException ex) {
            if (this.connectionBackoffStrategy.shouldBackoff(ex)) {
                this.backoffManager.backOff(route);
            }
            throw ex;
        }
        if (this.connectionBackoffStrategy.shouldBackoff(response)) {
            this.backoffManager.backOff(route);
        } else {
            this.backoffManager.probe(route);
        }
        return response;
    }
}

