/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachehttp.client5.http.impl.async;

import io.opentelemetry.testing.internal.apachehttp.client5.http.HttpRoute;
import io.opentelemetry.testing.internal.apachehttp.client5.http.async.AsyncExecRuntime;
import io.opentelemetry.testing.internal.apachehttp.client5.http.auth.AuthSchemeFactory;
import io.opentelemetry.testing.internal.apachehttp.client5.http.auth.CredentialsProvider;
import io.opentelemetry.testing.internal.apachehttp.client5.http.config.RequestConfig;
import io.opentelemetry.testing.internal.apachehttp.client5.http.cookie.CookieSpecFactory;
import io.opentelemetry.testing.internal.apachehttp.client5.http.cookie.CookieStore;
import io.opentelemetry.testing.internal.apachehttp.client5.http.impl.async.AsyncExecChainElement;
import io.opentelemetry.testing.internal.apachehttp.client5.http.impl.async.AsyncPushConsumerRegistry;
import io.opentelemetry.testing.internal.apachehttp.client5.http.impl.async.InternalAbstractHttpAsyncClient;
import io.opentelemetry.testing.internal.apachehttp.client5.http.impl.async.InternalHttpAsyncExecRuntime;
import io.opentelemetry.testing.internal.apachehttp.client5.http.nio.AsyncClientConnectionManager;
import io.opentelemetry.testing.internal.apachehttp.client5.http.protocol.HttpClientContext;
import io.opentelemetry.testing.internal.apachehttp.client5.http.routing.HttpRoutePlanner;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Contract;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.Internal;
import io.opentelemetry.testing.internal.apachehttp.core5.annotation.ThreadingBehavior;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpException;
import io.opentelemetry.testing.internal.apachehttp.core5.http.HttpHost;
import io.opentelemetry.testing.internal.apachehttp.core5.http.config.Lookup;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.AsyncPushConsumer;
import io.opentelemetry.testing.internal.apachehttp.core5.http.nio.HandlerFactory;
import io.opentelemetry.testing.internal.apachehttp.core5.http2.HttpVersionPolicy;
import io.opentelemetry.testing.internal.apachehttp.core5.reactor.DefaultConnectingIOReactor;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
@Internal
public final class InternalHttpAsyncClient
extends InternalAbstractHttpAsyncClient {
    private static final Logger LOG = LoggerFactory.getLogger(InternalHttpAsyncClient.class);
    private final AsyncClientConnectionManager manager;
    private final HttpRoutePlanner routePlanner;
    private final HttpVersionPolicy versionPolicy;

    InternalHttpAsyncClient(DefaultConnectingIOReactor ioReactor, AsyncExecChainElement execChain, AsyncPushConsumerRegistry pushConsumerRegistry, ThreadFactory threadFactory, AsyncClientConnectionManager manager, HttpRoutePlanner routePlanner, HttpVersionPolicy versionPolicy, Lookup<CookieSpecFactory> cookieSpecRegistry, Lookup<AuthSchemeFactory> authSchemeRegistry, CookieStore cookieStore, CredentialsProvider credentialsProvider, RequestConfig defaultConfig, List<Closeable> closeables) {
        super(ioReactor, pushConsumerRegistry, threadFactory, execChain, cookieSpecRegistry, authSchemeRegistry, cookieStore, credentialsProvider, defaultConfig, closeables);
        this.manager = manager;
        this.routePlanner = routePlanner;
        this.versionPolicy = versionPolicy;
    }

    @Override
    AsyncExecRuntime createAsyncExecRuntime(HandlerFactory<AsyncPushConsumer> pushHandlerFactory, HttpRoute route) {
        HttpVersionPolicy actualVersionPolicy = route.isTunnelled() && this.versionPolicy == HttpVersionPolicy.NEGOTIATE ? HttpVersionPolicy.FORCE_HTTP_1 : this.versionPolicy;
        return new InternalHttpAsyncExecRuntime(LOG, this.manager, this.getConnectionInitiator(), pushHandlerFactory, actualVersionPolicy);
    }

    @Override
    HttpRoute determineRoute(HttpHost httpHost, HttpClientContext clientContext) throws HttpException {
        HttpRoute route = this.routePlanner.determineRoute(httpHost, clientContext);
        if (route.isTunnelled() && this.versionPolicy == HttpVersionPolicy.FORCE_HTTP_2) {
            throw new HttpException("HTTP/2 tunneling not supported");
        }
        return route;
    }
}

