/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.apachecommons.fileupload.portlet;

import io.opentelemetry.testing.internal.apachecommons.fileupload.UploadContext;
import java.io.IOException;
import java.io.InputStream;
import javax.portlet.ActionRequest;

public class PortletRequestContext
implements UploadContext {
    private final ActionRequest request;

    public PortletRequestContext(ActionRequest request) {
        this.request = request;
    }

    @Override
    public long contentLength() {
        long size;
        try {
            size = Long.parseLong(this.request.getProperty("Content-length"));
        }
        catch (NumberFormatException e) {
            size = this.request.getContentLength();
        }
        return size;
    }

    @Override
    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    @Override
    @Deprecated
    public int getContentLength() {
        return this.request.getContentLength();
    }

    @Override
    public String getContentType() {
        return this.request.getContentType();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.request.getPortletInputStream();
    }

    public String toString() {
        return String.format("ContentLength=%s, ContentType=%s", this.contentLength(), this.getContentType());
    }
}

