/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.testing.junit.http;

import io.opentelemetry.instrumentation.test.utils.PortUtils;
import io.opentelemetry.instrumentation.testing.AgentTestRunner;
import io.opentelemetry.instrumentation.testing.InstrumentationTestRunner;
import io.opentelemetry.instrumentation.testing.LibraryTestRunner;
import io.opentelemetry.instrumentation.testing.junit.InstrumentationExtension;
import io.opentelemetry.instrumentation.testing.junit.http.AbstractHttpServerUsingTest;
import io.opentelemetry.testing.internal.armeria.client.ClientFactory;
import io.opentelemetry.testing.internal.armeria.client.WebClient;
import io.opentelemetry.testing.internal.armeria.client.WebClientBuilder;
import io.opentelemetry.testing.internal.armeria.client.logging.LoggingClient;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import java.time.Duration;
import org.junit.jupiter.api.extension.ExtensionContext;

public final class HttpServerInstrumentationExtension
extends InstrumentationExtension {
    private final int port = PortUtils.findOpenPort();
    private final WebClient client = ((WebClientBuilder)WebClient.builder().responseTimeout(Duration.ofMinutes(1L)).writeTimeout(Duration.ofMinutes(1L)).factory(ClientFactory.builder().connectTimeout(Duration.ofMinutes(1L)).build()).setHeader(HttpHeaderNames.USER_AGENT, "test-user-agent").setHeader(HttpHeaderNames.X_FORWARDED_FOR, "1.1.1.1").decorator(LoggingClient.newDecorator())).build();

    public static InstrumentationExtension forAgent() {
        return new HttpServerInstrumentationExtension(AgentTestRunner.instance());
    }

    public static InstrumentationExtension forLibrary() {
        return new HttpServerInstrumentationExtension(LibraryTestRunner.instance());
    }

    private HttpServerInstrumentationExtension(InstrumentationTestRunner runner) {
        super(runner);
    }

    @Override
    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        super.beforeAll(extensionContext);
        Object testInstance = extensionContext.getRequiredTestInstance();
        if (!(testInstance instanceof AbstractHttpServerUsingTest)) {
            throw new AssertionError((Object)"HttpServerInstrumentationExtension can only be applied to a subclass of AbstractHttpServerUsingTest");
        }
        ((AbstractHttpServerUsingTest)testInstance).setTesting(this.getTestRunner(), this.client, this.port);
    }
}

