/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.test.utils;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;

class PortAllocator {
    static final int CHUNK_SIZE = 100;
    static final int RANGE_MIN = 11000;
    static final int RANGE_MAX = 32768;
    private final PortBinder portBinder;
    private final List<Closeable> sockets = new ArrayList<Closeable>();
    private int next = 11000;
    private int nextChunkStart = 11000;

    PortAllocator() {
        this(PortBinder.INSTANCE);
    }

    PortAllocator(PortBinder portBinder) {
        this.portBinder = portBinder;
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            for (Closeable socket : this.sockets) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }));
    }

    int getPort() {
        return this.getPorts(1);
    }

    synchronized int getPorts(int count) {
        if (count < 1 || count >= 100) {
            throw new IllegalStateException("Invalid count " + count);
        }
        while (this.next + count - 1 <= 32768) {
            if (this.next + count - 1 >= this.nextChunkStart) {
                this.reserveNextChunk();
            }
            while (this.next + count - 1 < this.nextChunkStart && this.next + count - 1 <= 32768) {
                int port;
                int result = this.next;
                for (int i = 0; i < count && this.portBinder.canBind(port = this.next++); ++i) {
                    if (i != count - 1) continue;
                    return result;
                }
            }
        }
        throw new IllegalStateException("Failed to find suitable port");
    }

    private void reserveNextChunk() {
        while (this.nextChunkStart < 32768) {
            Closeable serverSocket = this.portBinder.bind(this.nextChunkStart);
            if (serverSocket != null) {
                this.sockets.add(serverSocket);
                this.next = this.nextChunkStart + 1;
                this.nextChunkStart += 100;
                return;
            }
            this.nextChunkStart += 100;
        }
        throw new IllegalStateException("Failed to reserve suitable port range");
    }

    static class PortBinder {
        static final PortBinder INSTANCE = new PortBinder();

        PortBinder() {
        }

        Closeable bind(int port) {
            try {
                return new ServerSocket(port);
            }
            catch (IOException exception) {
                return null;
            }
        }

        boolean canBind(int port) {
            try {
                ServerSocket socket = new ServerSocket(port);
                socket.close();
                return true;
            }
            catch (IOException exception) {
                return false;
            }
        }
    }
}

