/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.test.utils;

import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeoutException;

public final class GcUtils {
    private static final StringBuilder garbage = new StringBuilder();

    public static void awaitGc(Duration timeout) throws InterruptedException, TimeoutException {
        Object obj = new Object();
        WeakReference<Object> ref = new WeakReference<Object>(obj);
        obj = null;
        GcUtils.awaitGc(ref, timeout);
    }

    public static void awaitGc(WeakReference<?> ref, Duration timeout) throws InterruptedException, TimeoutException {
        long start = System.currentTimeMillis();
        while (ref.get() != null && !timeout.minus(System.currentTimeMillis() - start, ChronoUnit.MILLIS).isNegative()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            for (int i = 0; i < 26; ++i) {
                if (garbage.length() == 0) {
                    garbage.append("ab");
                    continue;
                }
                garbage.append((CharSequence)garbage);
            }
            garbage.setLength(0);
            System.gc();
        }
        if (ref.get() != null) {
            throw new TimeoutException("reference was not cleared in time");
        }
    }

    private GcUtils() {
    }
}

