/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification.diff;

import com.github.tomakehurst.wiremock.verification.diff.Diff;
import com.github.tomakehurst.wiremock.verification.diff.DiffLine;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.base.Joiner;
import io.opentelemetry.testing.internal.guava.collect.FluentIterable;
import java.util.List;

public class JUnitStyleDiffRenderer {
    private static Function<DiffLine<?>, Object> EXPECTED = new Function<DiffLine<?>, Object>(){

        @Override
        public Object apply(DiffLine<?> line) {
            return line.isForNonMatch() ? line.getPrintedPatternValue() : line.getActual();
        }
    };
    private static Function<DiffLine<?>, Object> ACTUAL = new Function<DiffLine<?>, Object>(){

        @Override
        public Object apply(DiffLine<?> input) {
            return input.getActual();
        }
    };

    public String render(Diff diff) {
        List<DiffLine<?>> lines = diff.getLines();
        String expected = Joiner.on("\n").join(FluentIterable.from(lines).transform(EXPECTED));
        String actual = Joiner.on("\n").join(FluentIterable.from(lines).transform(ACTUAL));
        return lines.isEmpty() ? "" : JUnitStyleDiffRenderer.junitStyleDiffMessage(expected, actual);
    }

    public static String junitStyleDiffMessage(Object expected, Object actual) {
        return String.format(" expected:<\n%s> but was:<\n%s>", expected, actual);
    }
}

