/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.common.DataTruncationSettings;
import com.github.tomakehurst.wiremock.common.Errors;
import com.github.tomakehurst.wiremock.common.Timing;
import com.github.tomakehurst.wiremock.extension.PostServeActionDefinition;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import io.opentelemetry.testing.internal.guava.base.Function;
import io.opentelemetry.testing.internal.guava.base.Predicate;
import io.opentelemetry.testing.internal.jackson.annotation.JsonCreator;
import io.opentelemetry.testing.internal.jackson.annotation.JsonIgnore;
import io.opentelemetry.testing.internal.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

public class ServeEvent {
    private final UUID id;
    private final LoggedRequest request;
    private final StubMapping stubMapping;
    private final ResponseDefinition responseDefinition;
    private final LoggedResponse response;
    private final AtomicReference<Timing> timing;
    public static final Function<ServeEvent, LoggedRequest> TO_LOGGED_REQUEST = new Function<ServeEvent, LoggedRequest>(){

        @Override
        public LoggedRequest apply(ServeEvent serveEvent) {
            return serveEvent.getRequest();
        }
    };
    public static final Predicate<ServeEvent> NOT_MATCHED = new Predicate<ServeEvent>(){

        @Override
        public boolean apply(ServeEvent serveEvent) {
            return serveEvent.isNoExactMatch();
        }
    };

    @JsonCreator
    public ServeEvent(@JsonProperty(value="id") UUID id, @JsonProperty(value="request") LoggedRequest request, @JsonProperty(value="mapping") StubMapping stubMapping, @JsonProperty(value="responseDefinition") ResponseDefinition responseDefinition, @JsonProperty(value="response") LoggedResponse response, @JsonProperty(value="wasMatched") boolean ignoredReadOnly, @JsonProperty(value="timing") Timing timing) {
        this.id = id;
        this.request = request;
        this.responseDefinition = responseDefinition;
        this.stubMapping = stubMapping;
        this.response = response;
        this.timing = new AtomicReference<Timing>(timing);
    }

    public ServeEvent(LoggedRequest request, StubMapping stubMapping, ResponseDefinition responseDefinition) {
        this(UUID.randomUUID(), request, stubMapping, responseDefinition, null, false, null);
    }

    public static ServeEvent forUnmatchedRequest(LoggedRequest request) {
        return new ServeEvent(request, null, ResponseDefinition.notConfigured());
    }

    public static ServeEvent forBadRequest(LoggedRequest request, Errors errors) {
        return new ServeEvent(request, null, ResponseDefinition.badRequest(errors));
    }

    public static ServeEvent forBadRequestEntity(LoggedRequest request, Errors errors) {
        return new ServeEvent(request, null, ResponseDefinition.badRequestEntity(errors));
    }

    public static ServeEvent forNotAllowedRequest(LoggedRequest request, Errors errors) {
        return new ServeEvent(request, null, ResponseDefinition.notPermitted(errors));
    }

    public static ServeEvent of(LoggedRequest request, ResponseDefinition responseDefinition) {
        return new ServeEvent(request, null, responseDefinition);
    }

    public static ServeEvent of(LoggedRequest request, ResponseDefinition responseDefinition, StubMapping stubMapping) {
        return new ServeEvent(request, stubMapping, responseDefinition);
    }

    public ServeEvent complete(Response response, int processTimeMillis, DataTruncationSettings dataTruncationSettings) {
        return new ServeEvent(this.id, this.request, this.stubMapping, this.responseDefinition, LoggedResponse.from(response, dataTruncationSettings.getMaxResponseBodySize()), false, new Timing((int)response.getInitialDelay(), processTimeMillis));
    }

    public void afterSend(int responseSendTimeMillis) {
        this.timing.set(this.timing.get().withResponseSendTime(responseSendTimeMillis));
    }

    @JsonIgnore
    public boolean isNoExactMatch() {
        return !this.responseDefinition.wasConfigured();
    }

    public UUID getId() {
        return this.id;
    }

    public LoggedRequest getRequest() {
        return this.request;
    }

    public ResponseDefinition getResponseDefinition() {
        return this.responseDefinition;
    }

    public boolean getWasMatched() {
        return this.responseDefinition.wasConfigured();
    }

    public StubMapping getStubMapping() {
        return this.stubMapping;
    }

    public LoggedResponse getResponse() {
        return this.response;
    }

    public Timing getTiming() {
        return this.timing.get();
    }

    @JsonIgnore
    public List<PostServeActionDefinition> getPostServeActions() {
        return this.stubMapping != null && this.stubMapping.getPostServeActions() != null ? this.getStubMapping().getPostServeActions() : Collections.emptyList();
    }
}

