/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.MultipartValuePattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import io.opentelemetry.testing.internal.guava.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MultipartValuePatternBuilder {
    private String name = null;
    private Map<String, MultiValuePattern> headerPatterns = Maps.newLinkedHashMap();
    private List<ContentPattern<?>> bodyPatterns = new LinkedList();
    private MultipartValuePattern.MatchingType matchingType = MultipartValuePattern.MatchingType.ANY;

    public MultipartValuePatternBuilder() {
    }

    public MultipartValuePatternBuilder(String name) {
        this.withName(name);
    }

    public MultipartValuePatternBuilder matchingType(MultipartValuePattern.MatchingType type) {
        this.matchingType = type;
        return this;
    }

    public MultipartValuePatternBuilder withName(String name) {
        this.name = name;
        return this.withHeader("Content-Disposition", WireMock.containing("name=\"" + name + "\""));
    }

    public MultipartValuePatternBuilder withHeader(String name, StringValuePattern headerPattern) {
        this.headerPatterns.put(name, MultiValuePattern.of(headerPattern));
        return this;
    }

    public MultipartValuePatternBuilder withBody(ContentPattern<?> bodyPattern) {
        this.bodyPatterns.add(bodyPattern);
        return this;
    }

    public MultipartValuePattern build() {
        return this.headerPatterns.isEmpty() && this.bodyPatterns.isEmpty() ? null : (this.headerPatterns.isEmpty() ? new MultipartValuePattern(this.name, this.matchingType, null, this.bodyPatterns) : new MultipartValuePattern(this.name, this.matchingType, this.headerPatterns, this.bodyPatterns));
    }
}

