/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import io.opentelemetry.testing.internal.apachecommons.lang3.text.WordUtils;
import io.opentelemetry.testing.internal.guava.base.Charsets;
import java.nio.charset.Charset;

public class Strings {
    public static final Charset DEFAULT_CHARSET = Charsets.UTF_8;

    public static String stringFromBytes(byte[] bytes) {
        return Strings.stringFromBytes(bytes, DEFAULT_CHARSET);
    }

    public static String stringFromBytes(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static byte[] bytesFromString(String str) {
        return Strings.bytesFromString(str, DEFAULT_CHARSET);
    }

    public static byte[] bytesFromString(String str, Charset charset) {
        if (str == null) {
            return null;
        }
        return str.getBytes(charset);
    }

    public static String wrapIfLongestLineExceedsLimit(String s, int maxLineLength) {
        int longestLength = Strings.findLongestLineLength(s);
        if (longestLength > maxLineLength) {
            String wrapped = WordUtils.wrap(s, maxLineLength, null, true);
            return wrapped.replaceAll("(?m)^[ \t]*\r?\n", "");
        }
        return s;
    }

    private static int findLongestLineLength(String s) {
        String[] lines = s.split("\n");
        int longestLength = 0;
        for (String line : lines) {
            int length = line.length();
            if (length <= longestLength) continue;
            longestLength = length;
        }
        return longestLength;
    }
}

