/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKey;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SpanKeyProvider;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.ServerAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.internal.InternalNetworkAttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.DbAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.ErrorAttributes;
import javax.annotation.Nullable;

public final class DbClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE>,
SpanKeyProvider {
    private static final AttributeKey<String> DB_NAME = AttributeKey.stringKey("db.name");
    private static final AttributeKey<String> DB_SYSTEM = AttributeKey.stringKey("db.system");
    private static final AttributeKey<String> DB_USER = AttributeKey.stringKey("db.user");
    private static final AttributeKey<String> DB_CONNECTION_STRING = AttributeKey.stringKey("db.connection_string");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private final DbClientAttributesGetter<REQUEST, RESPONSE> getter;
    private final InternalNetworkAttributesExtractor<REQUEST, RESPONSE> internalNetworkExtractor;
    private final ServerAttributesExtractor<REQUEST, RESPONSE> serverAttributesExtractor;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        return new DbClientAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    DbClientAttributesExtractor(DbClientAttributesGetter<REQUEST, RESPONSE> getter) {
        this.getter = getter;
        this.internalNetworkExtractor = new InternalNetworkAttributesExtractor<REQUEST, RESPONSE>(getter, true, false);
        this.serverAttributesExtractor = ServerAttributesExtractor.create(getter);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        DbClientAttributesExtractor.onStartCommon(attributes, this.getter, request);
        this.serverAttributesExtractor.onStart(attributes, parentContext, request);
    }

    static <REQUEST, RESPONSE> void onStartCommon(AttributesBuilder attributes, DbClientAttributesGetter<REQUEST, RESPONSE> getter, REQUEST request) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_SYSTEM_NAME, SemconvStability.stableDbSystemName(getter.getDbSystem(request)));
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_NAMESPACE, getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_TEXT, getter.getDbQueryText(request));
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_OPERATION_NAME, getter.getDbOperationName(request));
            AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_QUERY_SUMMARY, getter.getDbQuerySummary(request));
        }
        if (SemconvStability.emitOldDatabaseSemconv()) {
            AttributesExtractorUtil.internalSet(attributes, DB_SYSTEM, getter.getDbSystem(request));
            AttributesExtractorUtil.internalSet(attributes, DB_USER, getter.getUser(request));
            AttributesExtractorUtil.internalSet(attributes, DB_NAME, getter.getDbNamespace(request));
            AttributesExtractorUtil.internalSet(attributes, DB_CONNECTION_STRING, getter.getConnectionString(request));
            AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, getter.getDbQueryText(request));
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, getter.getDbOperationName(request));
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.internalNetworkExtractor.onEnd(attributes, request, response);
        DbClientAttributesExtractor.onEndCommon(attributes, this.getter, response, error);
    }

    static <REQUEST, RESPONSE> void onEndCommon(AttributesBuilder attributes, DbClientAttributesGetter<REQUEST, RESPONSE> getter, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (SemconvStability.emitStableDatabaseSemconv()) {
            if (error != null) {
                AttributesExtractorUtil.internalSet(attributes, ErrorAttributes.ERROR_TYPE, error.getClass().getName());
            }
            if (error != null || response != null) {
                AttributesExtractorUtil.internalSet(attributes, DbAttributes.DB_RESPONSE_STATUS_CODE, getter.getResponseStatus(response, error));
            }
        }
    }

    @Override
    public SpanKey internalGetSpanKey() {
        return SpanKey.DB_CLIENT;
    }
}

