/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.config.ConfigProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.incubator.config.DeclarativeConfigProperties;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public class InstrumentationConfigUtil {
    @Nullable
    public static Map<String, String> peerServiceMapping(ConfigProvider configProvider) {
        List serviceMappingList = InstrumentationConfigUtil.getOrNull(configProvider, config -> config.getStructuredList("service_mapping"), "general", "peer");
        if (serviceMappingList == null) {
            return null;
        }
        LinkedHashMap<String, String> serviceMapping = new LinkedHashMap<String, String>();
        serviceMappingList.forEach(entry -> {
            String peer = entry.getString("peer");
            String service = entry.getString("service");
            if (peer != null && service != null) {
                serviceMapping.put(peer, service);
            }
        });
        return serviceMapping.isEmpty() ? null : serviceMapping;
    }

    @Nullable
    public static List<String> httpClientRequestCapturedHeaders(ConfigProvider configProvider) {
        return InstrumentationConfigUtil.getOrNull(configProvider, config -> config.getScalarList("request_captured_headers", String.class), "general", "http", "client");
    }

    @Nullable
    public static List<String> httpClientResponseCapturedHeaders(ConfigProvider configProvider) {
        return InstrumentationConfigUtil.getOrNull(configProvider, config -> config.getScalarList("response_captured_headers", String.class), "general", "http", "client");
    }

    @Nullable
    public static List<String> httpServerRequestCapturedHeaders(ConfigProvider configProvider) {
        return InstrumentationConfigUtil.getOrNull(configProvider, config -> config.getScalarList("request_captured_headers", String.class), "general", "http", "server");
    }

    @Nullable
    public static List<String> httpSeverResponseCapturedHeaders(ConfigProvider configProvider) {
        return InstrumentationConfigUtil.getOrNull(configProvider, config -> config.getScalarList("response_captured_headers", String.class), "general", "http", "server");
    }

    @Nullable
    public static DeclarativeConfigProperties javaInstrumentationConfig(ConfigProvider configProvider, String instrumentationName) {
        return InstrumentationConfigUtil.getOrNull(configProvider, config -> config.getStructured(instrumentationName), "java");
    }

    @Nullable
    public static <T> T getOrNull(ConfigProvider configProvider, Function<DeclarativeConfigProperties, T> accessor, String ... segments) {
        DeclarativeConfigProperties config = configProvider.getInstrumentationConfig();
        if (config == null) {
            return null;
        }
        for (String segment : segments) {
            if ((config = config.getStructured(segment)) != null) continue;
            return null;
        }
        return accessor.apply(config);
    }

    private InstrumentationConfigUtil() {
    }

    @Nullable
    public static <T> T getInstrumentationConfigModel(ConfigProvider configProvider, String instrumentationName, ObjectMapper objectMapper, Class<T> modelType) {
        DeclarativeConfigProperties properties = InstrumentationConfigUtil.javaInstrumentationConfig(configProvider, instrumentationName);
        if (properties == null) {
            return null;
        }
        Map<String, Object> configPropertiesMap = DeclarativeConfigProperties.toMap(properties);
        return (T)objectMapper.convertValue(configPropertiesMap, modelType);
    }
}

