/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.javaagent.shaded.instrumentation.api.annotations.UnstableApi;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.RequestMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.AutoValue_HttpClientMetrics_State;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.concurrent.TimeUnit;

@UnstableApi
public final class HttpClientMetrics
implements RequestListener {
    private static final double NANOS_PER_MS = TimeUnit.MILLISECONDS.toNanos(1L);
    private static final ContextKey<State> HTTP_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("http-client-request-metrics-state");
    private static final Logger logger = LoggerFactory.getLogger(HttpClientMetrics.class);
    private final DoubleHistogram duration;

    @UnstableApi
    public static RequestMetrics get() {
        return HttpClientMetrics::new;
    }

    private HttpClientMetrics(Meter meter) {
        this.duration = meter.histogramBuilder("http.client.duration").setUnit("milliseconds").setDescription("The duration of the outbound HTTP request").build();
    }

    @Override
    public Context start(Context context, Attributes requestAttributes) {
        long startTimeNanos = System.nanoTime();
        return context.with(HTTP_CLIENT_REQUEST_METRICS_STATE, new AutoValue_HttpClientMetrics_State(requestAttributes, startTimeNanos));
    }

    @Override
    public void end(Context context, Attributes responseAttributes) {
        State state = context.get(HTTP_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.debug("No state present when ending context {}. Cannot record HTTP request metrics.", (Object)context);
            return;
        }
        this.duration.record((double)(System.nanoTime() - state.startTimeNanos()) / NANOS_PER_MS, TemporaryMetricsView.applyDurationView(state.startAttributes()));
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

