/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.db.SqlStatementSanitizer;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.db.DbAttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SqlAttributesExtractor<REQUEST, RESPONSE>
extends DbAttributesExtractor<REQUEST, RESPONSE> {
    @Override
    protected final void onStart(AttributesBuilder attributes, REQUEST request) {
        super.onStart(attributes, request);
        AttributeKey<String> dbTable = this.dbTableAttribute();
        if (dbTable != null) {
            SqlAttributesExtractor.set(attributes, dbTable, this.table(request));
        }
    }

    @Override
    protected final @Nullable String statement(REQUEST request) {
        return this.sanitize(request).getFullStatement();
    }

    @Override
    protected final @Nullable String operation(REQUEST request) {
        return this.sanitize(request).getOperation();
    }

    protected final @Nullable String table(REQUEST request) {
        return this.sanitize(request).getTable();
    }

    private SqlStatementInfo sanitize(REQUEST request) {
        return SqlStatementSanitizer.sanitize(this.rawStatement(request));
    }

    protected abstract @Nullable AttributeKey<String> dbTableAttribute();

    protected abstract @Nullable String rawStatement(REQUEST var1);
}

