/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public final class ContextPropagationDebug {
    private static final Logger log = LoggerFactory.getLogger(ContextPropagationDebug.class);
    private static final ContextKey<List<Propagation>> THREAD_PROPAGATION_LOCATIONS = ContextKey.named("thread-propagation-locations");
    private static final boolean THREAD_PROPAGATION_DEBUGGER = Config.get().getBooleanProperty("otel.javaagent.experimental.thread-propagation-debugger.enabled", Config.get().isAgentDebugEnabled());
    private static final boolean FAIL_ON_CONTEXT_LEAK = Config.get().getBooleanProperty("otel.javaagent.testing.fail-on-context-leak", false);

    public static boolean isThreadPropagationDebuggerEnabled() {
        return THREAD_PROPAGATION_DEBUGGER;
    }

    public static Context appendLocations(Context context, StackTraceElement[] locations, Object carrier) {
        List<Propagation> currentLocations = ContextPropagationDebug.getPropagations(context);
        if (currentLocations == null) {
            currentLocations = new CopyOnWriteArrayList<Propagation>();
            context = context.with(THREAD_PROPAGATION_LOCATIONS, currentLocations);
        }
        currentLocations.add(0, new Propagation(carrier.getClass().getName(), locations));
        return context;
    }

    public static void debugContextLeakIfEnabled() {
        if (!ContextPropagationDebug.isThreadPropagationDebuggerEnabled()) {
            return;
        }
        Context current = Context.current();
        if (current != Context.root()) {
            log.error("Unexpected non-root current context found when extracting remote context!");
            Span currentSpan = Span.fromContextOrNull(current);
            if (currentSpan != null) {
                log.error("It contains this span: {}", (Object)currentSpan);
            }
            ContextPropagationDebug.debugContextPropagation(current);
            if (FAIL_ON_CONTEXT_LEAK) {
                throw new IllegalStateException("Context leak detected");
            }
        }
    }

    private static List<Propagation> getPropagations(Context context) {
        return context.get(THREAD_PROPAGATION_LOCATIONS);
    }

    private static void debugContextPropagation(Context context) {
        List<Propagation> propagations = ContextPropagationDebug.getPropagations(context);
        if (propagations != null) {
            StringBuilder sb = new StringBuilder();
            Iterator<Propagation> i = propagations.iterator();
            while (i.hasNext()) {
                Propagation entry = i.next();
                sb.append("\ncarrier of type: ").append(entry.carrierClassName);
                for (StackTraceElement ste : entry.location) {
                    sb.append("\n    ");
                    sb.append(ste);
                }
                if (!i.hasNext()) continue;
                sb.append("\nwhich was propagated from:");
            }
            log.error("a context leak was detected. it was propagated from:{}", (Object)sb);
        }
    }

    private ContextPropagationDebug() {
    }

    private static class Propagation {
        public final String carrierClassName;
        public final StackTraceElement[] location;

        public Propagation(String carrierClassName, StackTraceElement[] location) {
            this.carrierClassName = carrierClassName;
            this.location = location;
        }
    }
}

