/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetAttributesExtractor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class InetSocketAddressNetAttributesExtractor<REQUEST, RESPONSE>
extends NetAttributesExtractor<REQUEST, RESPONSE> {
    public abstract @Nullable InetSocketAddress getAddress(REQUEST var1, @Nullable RESPONSE var2);

    @Override
    public final @Nullable String peerName(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        if (address.getAddress() != null) {
            return address.getAddress().getHostName();
        }
        return address.getHostString();
    }

    @Override
    public final @Nullable Integer peerPort(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        return address.getPort();
    }

    @Override
    public final @Nullable String peerIp(REQUEST request, @Nullable RESPONSE response) {
        InetSocketAddress address = this.getAddress(request, response);
        if (address == null) {
            return null;
        }
        InetAddress remoteAddress = address.getAddress();
        if (remoteAddress != null) {
            return remoteAddress.getHostAddress();
        }
        return null;
    }
}

