/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.HttpMessageBodySizeUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.http.TemporaryMetricsView;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.logging.Level;

public final class HttpClientExperimentalMetrics
implements OperationListener {
    private static final ContextKey<Attributes> HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES = ContextKey.named("http-client-experimental-metrics-start-attributes");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpClientExperimentalMetrics.class.getName());
    private final LongHistogram requestSize;
    private final LongHistogram responseSize;

    public static OperationMetrics get() {
        return HttpClientExperimentalMetrics::new;
    }

    private HttpClientExperimentalMetrics(Meter meter) {
        this.requestSize = meter.histogramBuilder("http.client.request.size").setUnit("By").setDescription("The size of HTTP request messages").ofLongs().build();
        this.responseSize = meter.histogramBuilder("http.client.response.size").setUnit("By").setDescription("The size of HTTP response messages").ofLongs().build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        return context.with(HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES, startAttributes);
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        Long responseBodySize;
        Attributes startAttributes = context.get(HTTP_CLIENT_REQUEST_METRICS_START_ATTRIBUTES);
        if (startAttributes == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP request metrics.", context);
            return;
        }
        Attributes sizeAttributes = TemporaryMetricsView.applyClientDurationAndSizeView(startAttributes, endAttributes);
        Long requestBodySize = HttpMessageBodySizeUtil.getHttpRequestBodySize(endAttributes, startAttributes);
        if (requestBodySize != null) {
            this.requestSize.record(requestBodySize, sizeAttributes, context);
        }
        if ((responseBodySize = HttpMessageBodySizeUtil.getHttpResponseBodySize(endAttributes, startAttributes)) != null) {
            this.responseSize.record(responseBodySize, sizeAttributes, context);
        }
    }
}

