/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.internal.FallbackNamePortGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;

public final class InternalNetServerAttributesExtractor<REQUEST, RESPONSE> {
    private final NetServerAttributesGetter<REQUEST, RESPONSE> getter;
    private final FallbackNamePortGetter<REQUEST> fallbackNamePortGetter;
    private final boolean emitOldHttpAttributes;

    public InternalNetServerAttributesExtractor(NetServerAttributesGetter<REQUEST, RESPONSE> getter, FallbackNamePortGetter<REQUEST> fallbackNamePortGetter, boolean emitOldHttpAttributes) {
        this.getter = getter;
        this.fallbackNamePortGetter = fallbackNamePortGetter;
        this.emitOldHttpAttributes = emitOldHttpAttributes;
    }

    public void onStart(AttributesBuilder attributes, REQUEST request) {
        if (this.emitOldHttpAttributes) {
            String sockFamily;
            String serverSocketAddress;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_TRANSPORT, this.getter.getTransport(request));
            boolean setSockFamily = false;
            String clientSocketAddress = this.getter.getClientSocketAddress(request, null);
            if (clientSocketAddress != null) {
                setSockFamily = true;
            }
            if ((serverSocketAddress = this.getter.getServerSocketAddress(request, null)) != null && !serverSocketAddress.equals(this.extractServerAddress(request))) {
                setSockFamily = true;
            }
            if (setSockFamily && (sockFamily = this.getter.getSockFamily(request)) != null && !"inet".equals(sockFamily)) {
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.NET_SOCK_FAMILY, sockFamily);
            }
        }
    }

    private String extractServerAddress(REQUEST request) {
        String serverAddress = this.getter.getServerAddress(request);
        if (serverAddress == null) {
            serverAddress = this.fallbackNamePortGetter.name(request);
        }
        return serverAddress;
    }
}

