/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.net.NetClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.util.Map;
import javax.annotation.Nullable;

public final class PeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final NetClientAttributesGetter<REQUEST, RESPONSE> attributesGetter;
    private final Map<String, String> peerServiceMapping;

    PeerServiceAttributesExtractor(NetClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, Map<String, String> peerServiceMapping) {
        this.attributesGetter = attributesGetter;
        this.peerServiceMapping = peerServiceMapping;
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(NetClientAttributesGetter<REQUEST, RESPONSE> attributesGetter, Map<String, String> peerServiceMapping) {
        return new PeerServiceAttributesExtractor<REQUEST, RESPONSE>(attributesGetter, peerServiceMapping);
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        if (this.peerServiceMapping.isEmpty()) {
            return;
        }
        String peerName = this.attributesGetter.getPeerName(request);
        String peerService = this.mapToPeerService(peerName);
        if (peerService == null) {
            String sockPeerName = this.attributesGetter.getSockPeerName(request, response);
            peerService = this.mapToPeerService(sockPeerName);
        }
        if (peerService != null) {
            attributes.put(SemanticAttributes.PEER_SERVICE, peerService);
        }
    }

    @Nullable
    private String mapToPeerService(String endpoint) {
        if (endpoint == null) {
            return null;
        }
        return this.peerServiceMapping.get(endpoint);
    }
}

