/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.caching;

import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.Cache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.CaffeineCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.caching.WeakLockFreeCache;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine.cache.Caffeine;
import java.util.concurrent.Executor;

public final class CacheBuilder {
    private static final long UNSET = -1L;
    private boolean weakKeys;
    private long maximumSize = -1L;
    private Executor executor = null;

    public CacheBuilder setMaximumSize(long maximumSize) {
        this.maximumSize = maximumSize;
        return this;
    }

    public CacheBuilder setWeakKeys() {
        this.weakKeys = true;
        return this;
    }

    CacheBuilder setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public <K, V> Cache<K, V> build() {
        if (this.weakKeys && this.maximumSize == -1L) {
            return new WeakLockFreeCache();
        }
        Caffeine<Object, Object> caffeine = Caffeine.newBuilder();
        if (this.weakKeys) {
            caffeine.weakKeys();
        }
        if (this.maximumSize != -1L) {
            caffeine.maximumSize(this.maximumSize);
        }
        if (this.executor != null) {
            caffeine.executor(this.executor);
        } else {
            caffeine.executor(Runnable::run);
        }
        io.opentelemetry.javaagent.shaded.instrumentation.api.internal.shaded.caffeine.cache.Cache delegate = caffeine.build();
        return new CaffeineCache(delegate);
    }

    CacheBuilder() {
    }
}

