/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.servlet;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import java.util.concurrent.atomic.AtomicBoolean;

public class AppServerBridge {
    private static final ContextKey<AppServerBridge> CONTEXT_KEY = ContextKey.named("opentelemetry-servlet-app-server-bridge");
    private final AtomicBoolean servletUpdatedServerSpanName = new AtomicBoolean(false);
    private final AtomicBoolean servletShouldRecordException;

    public static Context init(Context ctx) {
        return AppServerBridge.init(ctx, true);
    }

    public static Context init(Context ctx, boolean shouldRecordException) {
        return ctx.with(CONTEXT_KEY, new AppServerBridge(shouldRecordException));
    }

    private AppServerBridge(boolean shouldRecordException) {
        this.servletShouldRecordException = new AtomicBoolean(shouldRecordException);
    }

    public static boolean shouldUpdateServerSpanName(Context ctx) {
        AppServerBridge appServerBridge = ctx.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            return !appServerBridge.servletUpdatedServerSpanName.get();
        }
        return false;
    }

    public static void setServletUpdatedServerSpanName(Context ctx, boolean value) {
        AppServerBridge appServerBridge = ctx.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            appServerBridge.servletUpdatedServerSpanName.set(value);
        }
    }

    public static boolean shouldRecordException(Context ctx) {
        AppServerBridge appServerBridge = ctx.get(CONTEXT_KEY);
        if (appServerBridge != null) {
            return appServerBridge.servletShouldRecordException.get();
        }
        return true;
    }

    public static Class<?> getCallDepthKey() {
        class Key {
            Key() {
            }
        }
        return Key.class;
    }
}

