/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.resources;

import com.google.auto.service.AutoService;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizer;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalResourceDetectionModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalResourceDetectorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ResourceModel;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@AutoService(value={DeclarativeConfigurationCustomizerProvider.class})
public class ResourceCustomizerProvider
implements DeclarativeConfigurationCustomizerProvider {
    private static final List<String> REQUIRED_DETECTORS = Collections.singletonList("opentelemetry_javaagent_distribution");

    public void customize(DeclarativeConfigurationCustomizer customizer) {
        customizer.addModelCustomizer(model -> {
            ExperimentalResourceDetectionModel detectionModel;
            ResourceModel resource = model.getResource();
            if (resource == null) {
                resource = new ResourceModel();
                model.withResource(resource);
            }
            if ((detectionModel = resource.getDetectionDevelopment()) == null) {
                detectionModel = new ExperimentalResourceDetectionModel();
                resource.withDetectionDevelopment(detectionModel);
            }
            List detectors = Objects.requireNonNull(detectionModel.getDetectors());
            Set names = detectors.stream().flatMap(detector -> detector.getAdditionalProperties().keySet().stream()).collect(Collectors.toSet());
            for (String name : REQUIRED_DETECTORS) {
                if (names.contains(name)) continue;
                ExperimentalResourceDetectorModel detector2 = new ExperimentalResourceDetectorModel();
                detector2.getAdditionalProperties().put(name, null);
                detectors.add(0, detector2);
            }
            return model;
        });
    }
}

