/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizer;
import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigurationCustomizerProvider;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ConsoleExporterModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OpenTelemetryConfigurationModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SimpleSpanProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanExporterModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.TracerProviderModel;

@AutoService(value={DeclarativeConfigurationCustomizerProvider.class})
public class SpanLoggingCustomizerProvider
implements DeclarativeConfigurationCustomizerProvider {
    public void customize(DeclarativeConfigurationCustomizer customizer) {
        customizer.addModelCustomizer(model -> {
            SpanLoggingCustomizerProvider.maybeEnableLoggingExporter(model);
            return model;
        });
    }

    private static void maybeEnableLoggingExporter(OpenTelemetryConfigurationModel model) {
        if (!ConfigPropertiesUtil.getBoolean((String)"otel.javaagent.debug", (boolean)false)) {
            return;
        }
        if (SpanLoggingCustomizerProvider.loggingExporterIsAlreadyConfigured(model)) {
            return;
        }
        TracerProviderModel tracerProvider = model.getTracerProvider();
        if (tracerProvider == null) {
            tracerProvider = new TracerProviderModel();
            model.withTracerProvider(tracerProvider);
        }
        SpanProcessorModel processor = new SpanProcessorModel().withSimple(new SimpleSpanProcessorModel().withExporter(new SpanExporterModel().withConsole(new ConsoleExporterModel())));
        tracerProvider.getProcessors().add(processor);
    }

    private static boolean loggingExporterIsAlreadyConfigured(OpenTelemetryConfigurationModel model) {
        TracerProviderModel tracerProvider = model.getTracerProvider();
        if (tracerProvider == null) {
            return false;
        }
        for (SpanProcessorModel processor : tracerProvider.getProcessors()) {
            SpanExporterModel exporter;
            SimpleSpanProcessorModel simple = processor.getSimple();
            if (simple == null || (exporter = simple.getExporter()) == null || exporter.getConsole() == null) continue;
            return true;
        }
        return false;
    }
}

