/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.bootstrap.InstrumentationHolder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.AgentExtension;
import io.opentelemetry.javaagent.tooling.SafeServiceLoader;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.instrumentation.InstrumentationModuleInstaller;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.bytebuddy.agent.builder.AgentBuilder;

@AutoService(value={AgentExtension.class})
public class InstrumentationLoader
implements AgentExtension {
    private static final Logger logger = Logger.getLogger(InstrumentationLoader.class.getName());
    private final InstrumentationModuleInstaller instrumentationModuleInstaller = new InstrumentationModuleInstaller(InstrumentationHolder.getInstrumentation());

    @Override
    public AgentBuilder extend(AgentBuilder agentBuilder, ConfigProperties config) {
        int numberOfLoadedModules = 0;
        for (InstrumentationModule instrumentationModule : SafeServiceLoader.loadOrdered(InstrumentationModule.class, Utils.getExtensionsClassLoader())) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Loading instrumentation {0} [class {1}]", new Object[]{instrumentationModule.instrumentationName(), instrumentationModule.getClass().getName()});
            }
            try {
                agentBuilder = this.instrumentationModuleInstaller.install(instrumentationModule, agentBuilder, config);
                ++numberOfLoadedModules;
            }
            catch (Exception | LinkageError e) {
                logger.log(Level.SEVERE, "Unable to load instrumentation " + instrumentationModule.instrumentationName() + " [class " + instrumentationModule.getClass().getName() + "]", e);
            }
        }
        logger.log(Level.FINE, "Installed {0} instrumentation(s)", numberOfLoadedModules);
        return agentBuilder;
    }

    @Override
    public String extensionName() {
        return "instrumentation-loader";
    }
}

