/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.ignore;

import io.opentelemetry.instrumentation.api.cache.Cache;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.tooling.ignore.IgnoreAllow;
import io.opentelemetry.javaagent.tooling.util.Trie;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IgnoredClassLoadersMatcher
extends ElementMatcher.Junction.AbstractBase<ClassLoader> {
    private static final Logger logger = LoggerFactory.getLogger(IgnoredClassLoadersMatcher.class);
    private static final Cache<ClassLoader, Boolean> skipCache = Cache.weak();
    private final Trie<IgnoreAllow> ignoredClassLoaders;

    public IgnoredClassLoadersMatcher(Trie<IgnoreAllow> ignoredClassLoaders) {
        this.ignoredClassLoaders = ignoredClassLoaders;
    }

    public boolean matches(ClassLoader cl) {
        if (cl == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
            return false;
        }
        String name = cl.getClass().getName();
        IgnoreAllow ignored = this.ignoredClassLoaders.getOrNull(name);
        if (ignored == IgnoreAllow.ALLOW) {
            return false;
        }
        if (ignored == IgnoreAllow.IGNORE) {
            return true;
        }
        return (Boolean)skipCache.computeIfAbsent((Object)cl, c -> !IgnoredClassLoadersMatcher.delegatesToBootstrap(cl));
    }

    private static boolean delegatesToBootstrap(ClassLoader loader) {
        boolean delegates = true;
        if (!IgnoredClassLoadersMatcher.loadsExpectedClass(loader, PatchLogger.class)) {
            logger.debug("loader {} failed to delegate bootstrap agent class", (Object)loader);
            delegates = false;
        }
        return delegates;
    }

    private static boolean loadsExpectedClass(ClassLoader loader, Class<?> expectedClass) {
        try {
            return loader.loadClass(expectedClass.getName()) == expectedClass;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

