/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation;

import io.opentelemetry.javaagent.extension.instrumentation.HelperResourceBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationContextBuilder;
import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.instrumentation.TypeInstrumentation;
import io.opentelemetry.javaagent.extension.instrumentation.TypeTransformer;
import io.opentelemetry.javaagent.instrumentation.api.InstrumentationContext;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.bytebuddy.LoggingFailSafeMatcher;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.context.InstrumentationContextProvider;
import io.opentelemetry.javaagent.tooling.context.NoopContextProvider;
import io.opentelemetry.javaagent.tooling.instrumentation.ConstantAdjuster;
import io.opentelemetry.javaagent.tooling.instrumentation.TypeTransformerImpl;
import io.opentelemetry.javaagent.tooling.muzzle.ContextStoreMappings;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResourceBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.InstrumentationContextBuilderImpl;
import io.opentelemetry.javaagent.tooling.muzzle.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.ReferenceMatcher;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.annotation.AnnotationSource;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentationModuleInstaller {
    private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(InstrumentationModule.class);
    private static final Logger muzzleLogger = LoggerFactory.getLogger((String)"muzzleMatcher");
    private final Instrumentation instrumentation;
    public static final ElementMatcher.Junction<AnnotationSource> NOT_DECORATOR_MATCHER = ElementMatchers.not((ElementMatcher)ElementMatchers.isAnnotatedWith((ElementMatcher)ElementMatchers.named((String)"javax.decorator.Decorator")));

    public InstrumentationModuleInstaller(Instrumentation instrumentation) {
        this.instrumentation = instrumentation;
    }

    AgentBuilder install(InstrumentationModule instrumentationModule, AgentBuilder parentAgentBuilder) {
        if (!instrumentationModule.isEnabled()) {
            logger.debug("Instrumentation {} is disabled", (Object)instrumentationModule.instrumentationName());
            return parentAgentBuilder;
        }
        List helperClassNames = instrumentationModule.getMuzzleHelperClassNames();
        HelperResourceBuilderImpl helperResourceBuilder = new HelperResourceBuilderImpl();
        List helperResourceNames = instrumentationModule.helperResourceNames();
        for (String helperResourceName : helperResourceNames) {
            helperResourceBuilder.register(helperResourceName);
        }
        instrumentationModule.registerHelperResources((HelperResourceBuilder)helperResourceBuilder);
        List typeInstrumentations = instrumentationModule.typeInstrumentations();
        if (typeInstrumentations.isEmpty()) {
            if (!helperClassNames.isEmpty() || !helperResourceBuilder.getResources().isEmpty()) {
                logger.warn("Helper classes and resources won't be injected if no types are instrumented: {}", (Object)instrumentationModule.instrumentationName());
            }
            return parentAgentBuilder;
        }
        ElementMatcher.Junction moduleClassLoaderMatcher = instrumentationModule.classLoaderMatcher();
        MuzzleMatcher muzzleMatcher = new MuzzleMatcher(instrumentationModule);
        HelperInjector helperInjector = new HelperInjector(instrumentationModule.instrumentationName(), helperClassNames, helperResourceBuilder.getResources(), Utils.getExtensionsClassLoader(), this.instrumentation);
        InstrumentationContextProvider contextProvider = InstrumentationModuleInstaller.createInstrumentationContextProvider(instrumentationModule);
        AgentBuilder agentBuilder = parentAgentBuilder;
        for (TypeInstrumentation typeInstrumentation : typeInstrumentations) {
            AgentBuilder.Identified.Extendable extendableAgentBuilder = ((AgentBuilder.Identified.Narrowable)((AgentBuilder.Identified.Narrowable)agentBuilder.type(new LoggingFailSafeMatcher(typeInstrumentation.typeMatcher(), "Instrumentation type matcher unexpected exception: " + typeInstrumentation.typeMatcher()), new LoggingFailSafeMatcher(moduleClassLoaderMatcher.and(typeInstrumentation.classLoaderOptimization()), "Instrumentation class loader matcher unexpected exception: " + typeInstrumentation.classLoaderOptimization())).and(NOT_DECORATOR_MATCHER)).and((AgentBuilder.RawMatcher)muzzleMatcher)).transform(ConstantAdjuster.instance()).transform((AgentBuilder.Transformer)helperInjector);
            extendableAgentBuilder = contextProvider.instrumentationTransformer(extendableAgentBuilder);
            TypeTransformerImpl typeTransformer = new TypeTransformerImpl(extendableAgentBuilder);
            typeInstrumentation.transform((TypeTransformer)typeTransformer);
            extendableAgentBuilder = typeTransformer.getAgentBuilder();
            extendableAgentBuilder = contextProvider.additionalInstrumentation(extendableAgentBuilder);
            agentBuilder = extendableAgentBuilder;
        }
        return agentBuilder;
    }

    private static InstrumentationContextProvider createInstrumentationContextProvider(InstrumentationModule instrumentationModule) {
        InstrumentationContextBuilderImpl builder = new InstrumentationContextBuilderImpl();
        instrumentationModule.registerMuzzleContextStoreClasses((InstrumentationContextBuilder)builder);
        ContextStoreMappings mappings = builder.build();
        if (!mappings.isEmpty()) {
            return FieldBackedProviderFactory.get(instrumentationModule.getClass(), mappings);
        }
        return NoopContextProvider.INSTANCE;
    }

    private static class MuzzleMatcher
    implements AgentBuilder.RawMatcher {
        private final InstrumentationModule instrumentationModule;
        private final AtomicBoolean initialized = new AtomicBoolean(false);
        private volatile ReferenceMatcher referenceMatcher;

        private MuzzleMatcher(InstrumentationModule instrumentationModule) {
            this.instrumentationModule = instrumentationModule;
        }

        public boolean matches(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, Class<?> classBeingRedefined, ProtectionDomain protectionDomain) {
            boolean isMatch;
            ReferenceMatcher muzzle = this.getReferenceMatcher();
            if (classLoader == ClassLoadingStrategy.BOOTSTRAP_LOADER) {
                classLoader = Utils.getBootstrapProxy();
            }
            if (!(isMatch = muzzle.matches(classLoader))) {
                if (muzzleLogger.isWarnEnabled()) {
                    muzzleLogger.warn("Instrumentation skipped, mismatched references were found: {} [class {}] on {}", new Object[]{this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader});
                    List mismatches = muzzle.getMismatchedReferenceSources(classLoader);
                    for (Mismatch mismatch : mismatches) {
                        muzzleLogger.warn("-- {}", (Object)mismatch);
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Applying instrumentation: {} [class {}] on {}", new Object[]{this.instrumentationModule.instrumentationName(), this.instrumentationModule.getClass().getName(), classLoader});
            }
            return isMatch;
        }

        private ReferenceMatcher getReferenceMatcher() {
            if (this.initialized.compareAndSet(false, true)) {
                this.referenceMatcher = ReferenceMatcher.of((InstrumentationModule)this.instrumentationModule);
            }
            return this.referenceMatcher;
        }
    }

    private static class FieldBackedProviderFactory {
        private FieldBackedProviderFactory() {
        }

        static FieldBackedProvider get(Class<?> instrumenterClass, ContextStoreMappings contextStoreMappings) {
            return new FieldBackedProvider(instrumenterClass, contextStoreMappings);
        }

        static {
            InstrumentationContext.internalSetContextStoreSupplier((keyClass, contextClass) -> FieldBackedProvider.getContextStore(keyClass, contextClass));
        }
    }
}

