/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.metrics.GlobalMeterProvider;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.spi.exporter.MetricExporterFactory;
import io.opentelemetry.javaagent.spi.exporter.SpanExporterFactory;
import io.opentelemetry.javaagent.tooling.AddThreadDetailsSpanProcessor;
import io.opentelemetry.javaagent.tooling.ExporterClassLoader;
import io.opentelemetry.javaagent.tooling.OpenTelemetryInstaller;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.traces.SdkTracerProviderConfigurer;
import io.opentelemetry.sdk.metrics.SdkMeterProvider;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SdkTracerProviderConfigurer.class})
public class AgentTracerProviderConfigurer
implements SdkTracerProviderConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(AgentTracerProviderConfigurer.class);
    static final String EXPORTER_JAR_CONFIG = "otel.javaagent.experimental.exporter.jar";
    private static final String ADD_THREAD_DETAILS = "otel.javaagent.add-thread-details";

    public void configure(SdkTracerProviderBuilder sdkTracerProviderBuilder, ConfigProperties config) {
        if (!Config.get().getBoolean("otel.javaagent.enabled", true)) {
            return;
        }
        if (Config.get().getBoolean(ADD_THREAD_DETAILS, true)) {
            sdkTracerProviderBuilder.addSpanProcessor((SpanProcessor)new AddThreadDetailsSpanProcessor());
        }
        AgentTracerProviderConfigurer.maybeConfigureExporterJar(sdkTracerProviderBuilder);
        AgentTracerProviderConfigurer.maybeEnableLoggingExporter(sdkTracerProviderBuilder);
    }

    private static void maybeEnableLoggingExporter(SdkTracerProviderBuilder builder) {
        if (Config.get().isAgentDebugEnabled() && AgentTracerProviderConfigurer.loggingExporterIsNotAlreadyConfigured()) {
            builder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)new LoggingSpanExporter()));
        }
    }

    private static boolean loggingExporterIsNotAlreadyConfigured() {
        return !Config.get().getString("otel.traces.exporter", "").equalsIgnoreCase("logging");
    }

    private static void maybeConfigureExporterJar(SdkTracerProviderBuilder sdkTracerProviderBuilder) {
        Config config = Config.get();
        String exporterJar = config.getString(EXPORTER_JAR_CONFIG);
        if (exporterJar == null) {
            return;
        }
        AgentTracerProviderConfigurer.installExportersFromJar(exporterJar, config, sdkTracerProviderBuilder);
    }

    private static synchronized void installExportersFromJar(String exporterJar, Config config, SdkTracerProviderBuilder builder) {
        URL url;
        logger.warn("{} is deprecated and will be removed soon! Please use {}", (Object)EXPORTER_JAR_CONFIG, (Object)"otel.javaagent.extensions");
        try {
            url = new File(exporterJar).toURI().toURL();
        }
        catch (MalformedURLException e) {
            logger.warn("Filename could not be parsed: {}. Exporter is not installed", (Object)exporterJar);
            logger.warn("No valid exporter found. Tracing will run but spans are dropped");
            return;
        }
        ExporterClassLoader exporterLoader = new ExporterClassLoader(url, OpenTelemetryInstaller.class.getClassLoader());
        SpanExporterFactory spanExporterFactory = AgentTracerProviderConfigurer.getExporterFactory(SpanExporterFactory.class, exporterLoader);
        if (spanExporterFactory != null) {
            AgentTracerProviderConfigurer.installSpanExporter(spanExporterFactory, config, builder);
        } else {
            logger.warn("No span exporter found in {}", (Object)exporterJar);
            logger.warn("No valid exporter found. Tracing will run but spans are dropped");
        }
        MetricExporterFactory metricExporterFactory = AgentTracerProviderConfigurer.getExporterFactory(MetricExporterFactory.class, exporterLoader);
        if (metricExporterFactory != null) {
            AgentTracerProviderConfigurer.installMetricExporter(metricExporterFactory, config);
        }
    }

    private static <F> F getExporterFactory(Class<F> service, ExporterClassLoader exporterLoader) {
        ServiceLoader<F> serviceLoader = ServiceLoader.load(service, exporterLoader);
        Iterator<F> i = serviceLoader.iterator();
        if (i.hasNext()) {
            F factory = i.next();
            if (i.hasNext()) {
                logger.warn("Exporter JAR defines more than one {}. Only the first one found will be used", (Object)service.getName());
            }
            return factory;
        }
        return null;
    }

    private static void installSpanExporter(SpanExporterFactory spanExporterFactory, Config config, SdkTracerProviderBuilder builder) {
        SpanExporter spanExporter = spanExporterFactory.fromConfig(config.asJavaProperties());
        BatchSpanProcessor spanProcessor = BatchSpanProcessor.builder((SpanExporter)spanExporter).build();
        builder.addSpanProcessor((SpanProcessor)spanProcessor);
        logger.info("Installed span exporter: {}", (Object)spanExporter.getClass().getName());
    }

    private static void installMetricExporter(MetricExporterFactory metricExporterFactory, Config config) {
        MetricExporter metricExporter = metricExporterFactory.fromConfig(config.asJavaProperties());
        IntervalMetricReader.builder().setMetricExporter(metricExporter).setMetricProducers(Collections.singleton((SdkMeterProvider)GlobalMeterProvider.get())).buildAndStart();
        logger.info("Installed metric exporter: {}", (Object)metricExporter.getClass().getName());
    }
}

