/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.extension.AgentExtension;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.javaagent.extension.bootstrap.BootstrapPackagesBuilder;
import io.opentelemetry.javaagent.extension.bootstrap.BootstrapPackagesConfigurer;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesConfigurer;
import io.opentelemetry.javaagent.instrumentation.api.internal.BootstrapPackagePrefixesHolder;
import io.opentelemetry.javaagent.instrumentation.api.internal.InstrumentedTaskClasses;
import io.opentelemetry.javaagent.tooling.ExtensionClassLoader;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.LoggingConfigurer;
import io.opentelemetry.javaagent.tooling.SafeServiceLoader;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.VersionLogger;
import io.opentelemetry.javaagent.tooling.asyncannotationsupport.WeakRefAsyncOperationEndStrategies;
import io.opentelemetry.javaagent.tooling.bootstrap.BootstrapPackagesBuilderImpl;
import io.opentelemetry.javaagent.tooling.config.ConfigInitializer;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredClassLoadersMatcher;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesBuilderImpl;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesMatcher;
import io.opentelemetry.javaagent.tooling.muzzle.AgentTooling;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInstaller {
    private static final Logger logger;
    private static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    private static final String FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG = "otel.javaagent.experimental.force-synchronous-agent-listeners";
    private static final Map<String, List<Runnable>> CLASS_LOAD_CALLBACKS;

    public static void installBytebuddyAgent(Instrumentation inst) {
        AgentInstaller.logVersionInfo();
        Config config = Config.get();
        if (config.getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            List<AgentListener> agentListeners = SafeServiceLoader.loadOrdered(AgentListener.class);
            AgentInstaller.installBytebuddyAgent(inst, agentListeners);
        } else {
            logger.debug("Tracing is disabled, not installing instrumentations.");
        }
    }

    public static ResettableClassFileTransformer installBytebuddyAgent(Instrumentation inst, Iterable<AgentListener> agentListeners) {
        WeakRefAsyncOperationEndStrategies.initialize();
        Config config = Config.get();
        AgentInstaller.setBootstrapPackages(config);
        AgentInstaller.runBeforeAgentListeners(agentListeners, config);
        FieldBackedProvider.resetContextMatchers();
        AgentBuilder agentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.DescriptionStrategy)AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with((AgentBuilder.PoolStrategy)AgentTooling.poolStrategy()).with((AgentBuilder.Listener)new ClassLoadListener()).with((AgentBuilder.LocationStrategy)AgentTooling.locationStrategy((ClassLoader)Utils.getBootstrapProxy()));
        agentBuilder = AgentInstaller.configureIgnoredTypes(config, agentBuilder);
        if (logger.isDebugEnabled()) {
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.RedefinitionStrategy.Listener)new RedefinitionLoggingListener()).with((AgentBuilder.Listener)new TransformLoggingListener());
        }
        int numberOfLoadedExtensions = 0;
        for (AgentExtension agentExtension : SafeServiceLoader.loadOrdered(AgentExtension.class)) {
            logger.debug("Loading extension {} [class {}]", (Object)agentExtension.extensionName(), (Object)agentExtension.getClass().getName());
            try {
                agentBuilder = agentExtension.extend(agentBuilder);
                ++numberOfLoadedExtensions;
            }
            catch (Exception | LinkageError e) {
                logger.error("Unable to load extension {} [class {}]", new Object[]{agentExtension.extensionName(), agentExtension.getClass().getName(), e});
            }
        }
        logger.debug("Installed {} extension(s)", (Object)numberOfLoadedExtensions);
        ResettableClassFileTransformer resettableClassFileTransformer = agentBuilder.installOn(inst);
        AgentInstaller.runAfterAgentListeners(agentListeners, config);
        return resettableClassFileTransformer;
    }

    private static void setBootstrapPackages(Config config) {
        BootstrapPackagesBuilderImpl builder = new BootstrapPackagesBuilderImpl();
        for (BootstrapPackagesConfigurer configurer : SafeServiceLoader.load(BootstrapPackagesConfigurer.class)) {
            configurer.configure(config, (BootstrapPackagesBuilder)builder);
        }
        BootstrapPackagePrefixesHolder.setBoostrapPackagePrefixes(builder.build());
    }

    private static void runBeforeAgentListeners(Iterable<AgentListener> agentListeners, Config config) {
        for (AgentListener agentListener : agentListeners) {
            agentListener.beforeAgent(config);
        }
    }

    private static AgentBuilder configureIgnoredTypes(Config config, AgentBuilder agentBuilder) {
        IgnoredTypesBuilderImpl builder = new IgnoredTypesBuilderImpl();
        for (IgnoredTypesConfigurer configurer : SafeServiceLoader.loadOrdered(IgnoredTypesConfigurer.class)) {
            configurer.configure(config, (IgnoredTypesBuilder)builder);
        }
        InstrumentedTaskClasses.setIgnoredTaskClasses(builder.buildIgnoredTasksTrie());
        return (AgentBuilder)agentBuilder.ignore((ElementMatcher)ElementMatchers.any(), (ElementMatcher)new IgnoredClassLoadersMatcher(builder.buildIgnoredClassLoadersTrie())).or((ElementMatcher)new IgnoredTypesMatcher(builder.buildIgnoredTypesTrie()));
    }

    private static void runAfterAgentListeners(Iterable<AgentListener> agentListeners, Config config) {
        boolean shouldForceSynchronousAgentListenersCalls = Config.get().getBooleanProperty(FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG, false);
        if (!shouldForceSynchronousAgentListenersCalls && AgentInitializer.isJavaBefore9() && AgentInstaller.isAppUsingCustomLogManager()) {
            logger.debug("Custom JUL LogManager detected: delaying AgentListener#afterAgent() calls");
            AgentInstaller.registerClassLoadCallback("java.util.logging.LogManager", new DelayedAfterAgentCallback(config, agentListeners));
        } else {
            for (AgentListener agentListener : agentListeners) {
                agentListener.afterAgent(config);
            }
        }
    }

    private static void addByteBuddyRawSetting() {
        String savedPropertyValue = System.getProperty("net.bytebuddy.raw");
        try {
            System.setProperty("net.bytebuddy.raw", "true");
            boolean rawTypes = TypeDescription.AbstractBase.RAW_TYPES;
            if (!rawTypes) {
                logger.debug("Too late to enable {}", (Object)"net.bytebuddy.raw");
            }
        }
        finally {
            if (savedPropertyValue == null) {
                System.clearProperty("net.bytebuddy.raw");
            } else {
                System.setProperty("net.bytebuddy.raw", savedPropertyValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoadCallback(String className, Runnable callback) {
        Map<String, List<Runnable>> map = CLASS_LOAD_CALLBACKS;
        synchronized (map) {
            List callbacks = CLASS_LOAD_CALLBACKS.computeIfAbsent(className, k -> new ArrayList());
            callbacks.add(callback);
        }
    }

    private static boolean isAppUsingCustomLogManager() {
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            logger.debug("Found JBoss: {}; assuming app is using custom LogManager", (Object)jbossHome);
            return true;
        }
        String customLogManager = System.getProperty("java.util.logging.manager");
        if (customLogManager != null) {
            logger.debug("Detected custom LogManager configuration: java.util.logging.manager={}", (Object)customLogManager);
            boolean onSysClasspath = ClassLoader.getSystemResource(Utils.getResourceName(customLogManager)) != null;
            logger.debug("Class {} is on system classpath: {}delaying AgentInstaller#afterAgent()", (Object)customLogManager, (Object)(onSysClasspath ? "not " : ""));
            return !onSysClasspath;
        }
        return false;
    }

    private static void logVersionInfo() {
        VersionLogger.logAllVersions();
        logger.debug("{} loaded on {}", (Object)AgentInstaller.class.getName(), (Object)AgentInstaller.class.getClassLoader());
    }

    private AgentInstaller() {
    }

    static {
        CLASS_LOAD_CALLBACKS = new HashMap<String, List<Runnable>>();
        LoggingConfigurer.configureLogger();
        logger = LoggerFactory.getLogger(AgentInstaller.class);
        AgentInstaller.addByteBuddyRawSetting();
        ConfigInitializer.initialize();
        Proxy.class.getName();
        ForkJoinPool.class.getName();
        AtomicReferenceArray.class.getName();
    }

    private static class RedefinitionDiscoveryStrategy
    implements AgentBuilder.RedefinitionStrategy.DiscoveryStrategy {
        private static final AgentBuilder.RedefinitionStrategy.DiscoveryStrategy delegate = AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE;

        private RedefinitionDiscoveryStrategy() {
        }

        public Iterable<Iterable<Class<?>>> resolve(Instrumentation instrumentation) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(delegate.resolve(instrumentation)).map(RedefinitionDiscoveryStrategy::filterClasses).iterator();
        }

        private static Iterable<Class<?>> filterClasses(Iterable<Class<?>> classes) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(classes).filter(c -> !RedefinitionDiscoveryStrategy.isIgnored(c)).iterator();
        }

        private static <T> Stream<T> streamOf(Iterable<T> iterable) {
            return StreamSupport.stream(iterable.spliterator(), false);
        }

        private static boolean isIgnored(Class<?> c) {
            ClassLoader cl = c.getClassLoader();
            if (cl instanceof AgentClassLoader || cl instanceof ExtensionClassLoader) {
                return true;
            }
            if (c.getName().startsWith("java.lang.ClassLoader$ByteBuddyAccessor$")) {
                return true;
            }
            return HelperInjector.isInjectedClass(c);
        }
    }

    private static class ClassLoadListener
    implements AgentBuilder.Listener {
        private ClassLoadListener() {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b, DynamicType dynamicType) {
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onError(String s, ClassLoader classLoader, JavaModule javaModule, boolean b, Throwable throwable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
            Map map = CLASS_LOAD_CALLBACKS;
            synchronized (map) {
                List callbacks = (List)CLASS_LOAD_CALLBACKS.get(typeName);
                if (callbacks != null) {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                }
            }
        }
    }

    private static class DelayedAfterAgentCallback
    implements Runnable {
        private final Iterable<AgentListener> agentListeners;
        private final Config config;

        private DelayedAfterAgentCallback(Config config, Iterable<AgentListener> agentListeners) {
            this.agentListeners = agentListeners;
            this.config = config;
        }

        @Override
        public void run() {
            Thread thread = new Thread(this::runAgentListeners);
            thread.setName("delayed-agent-listeners");
            thread.setDaemon(true);
            thread.start();
        }

        private void runAgentListeners() {
            for (AgentListener agentListener : this.agentListeners) {
                try {
                    agentListener.afterAgent(this.config);
                }
                catch (RuntimeException e) {
                    logger.error("Failed to execute {}", (Object)agentListener.getClass().getName(), (Object)e);
                }
            }
        }
    }

    static class TransformLoggingListener
    implements AgentBuilder.Listener {
        private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(TransformLoggingListener.class);

        TransformLoggingListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to handle {} for transformation on classloader {}", new Object[]{typeName, classLoader, throwable});
            }
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            logger.debug("Transformed {} -- {}", (Object)typeDescription.getName(), (Object)classLoader);
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }
    }

    static class RedefinitionLoggingListener
    implements AgentBuilder.RedefinitionStrategy.Listener {
        private static final Logger logger = LoggerFactory.getLogger(RedefinitionLoggingListener.class);

        RedefinitionLoggingListener() {
        }

        public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
        }

        public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception while retransforming {} classes: {}", new Object[]{batch.size(), batch, throwable});
            }
            return Collections.emptyList();
        }

        public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
        }
    }
}

