/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.extension.noopapi.NoopOpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.javaagent.instrumentation.api.OpenTelemetrySdkAccess;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.OpenTelemetrySdkAutoConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.SdkMeterProviderConfigurer;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.export.IntervalMetricReader;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import io.opentelemetry.sdk.metrics.view.View;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={AgentListener.class})
public class OpenTelemetryInstaller
implements AgentListener {
    private static final Logger logger = LoggerFactory.getLogger(OpenTelemetryInstaller.class);
    static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    static final String JAVAAGENT_NOOP_CONFIG = "otel.javaagent.experimental.use-noop-api";

    public void beforeAgent(Config config) {
        OpenTelemetryInstaller.installAgentTracer(config);
    }

    public static synchronized void installAgentTracer(Config config) {
        if (config.getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            OpenTelemetryInstaller.copySystemProperties(config);
            if (config.getBooleanProperty(JAVAAGENT_NOOP_CONFIG, false)) {
                GlobalOpenTelemetry.set((OpenTelemetry)NoopOpenTelemetry.getInstance());
            } else {
                System.setProperty("io.opentelemetry.context.contextStorageProvider", "default");
                OpenTelemetrySdk sdk = OpenTelemetrySdkAutoConfiguration.initialize();
                OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> {
                    CompletableResultCode traceResult = sdk.getSdkTracerProvider().forceFlush();
                    CompletableResultCode flushResult = IntervalMetricReader.forceFlushGlobal();
                    CompletableResultCode.ofAll(Arrays.asList(traceResult, flushResult)).join((long)timeout, unit);
                });
            }
        } else {
            logger.info("Tracing is disabled.");
        }
    }

    private static void copySystemProperties(Config config) {
        Map allProperties = config.getAllProperties();
        Map environmentProperties = Config.newBuilder().readEnvironmentVariables().readSystemProperties().build().getAllProperties();
        allProperties.forEach((key, value) -> {
            if (!environmentProperties.containsKey(key) && key.startsWith("otel.") && !key.startsWith("otel.instrumentation")) {
                System.setProperty(key, value);
            }
        });
    }

    @AutoService(value={SdkMeterProviderConfigurer.class})
    public static final class OpenTelemetryMetricsConfigurer
    implements SdkMeterProviderConfigurer {
        public void configure(SdkMeterProviderBuilder sdkMeterProviderBuilder) {
            sdkMeterProviderBuilder.registerView(InstrumentSelector.builder().setInstrumentNameRegex(".*duration").setInstrumentType(InstrumentType.VALUE_RECORDER).build(), View.builder().setAggregatorFactory(AggregatorFactory.histogram(Arrays.asList(5.0, 10.0, 25.0, 50.0, 75.0, 100.0, 250.0, 500.0, 750.0, 1000.0, 2500.0, 5000.0, 7500.0, 10000.0), (AggregationTemporality)AggregationTemporality.CUMULATIVE)).build());
        }
    }
}

