/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.tooling.RemappingUrlStreamHandler;
import io.opentelemetry.javaagent.tooling.config.EarlyInitAgentConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Nullable;
import net.bytebuddy.dynamic.loading.MultipleParentClassLoader;

public class ExtensionClassLoader
extends URLClassLoader {
    public static final String EXTENSIONS_CONFIG = "otel.javaagent.extensions";
    private final boolean isSecurityManagerSupportEnabled;

    public static ClassLoader getInstance(ClassLoader parent, File javaagentFile, boolean isSecurityManagerSupportEnabled, EarlyInitAgentConfig earlyConfig) {
        ArrayList<URL> extensions = new ArrayList<URL>();
        ExtensionClassLoader.includeEmbeddedExtensionsIfFound(extensions, javaagentFile);
        extensions.addAll(ExtensionClassLoader.parseLocation(earlyConfig.getString(EXTENSIONS_CONFIG), javaagentFile));
        if (extensions.isEmpty()) {
            return parent;
        }
        ArrayList<URLClassLoader> delegates = new ArrayList<URLClassLoader>(extensions.size());
        for (URL url : extensions) {
            delegates.add(ExtensionClassLoader.getDelegate(parent, url, isSecurityManagerSupportEnabled));
        }
        return new MultipleParentClassLoader(parent, delegates);
    }

    private static void includeEmbeddedExtensionsIfFound(List<URL> extensions, File javaagentFile) {
        try {
            JarFile jarFile = new JarFile(javaagentFile, false);
            Enumeration<JarEntry> entryEnumeration = jarFile.entries();
            String prefix = "extensions/";
            File tempDirectory = null;
            while (entryEnumeration.hasMoreElements()) {
                JarEntry jarEntry = entryEnumeration.nextElement();
                String name = jarEntry.getName();
                if (!name.startsWith(prefix) || jarEntry.isDirectory()) continue;
                File tempFile = new File(tempDirectory = ExtensionClassLoader.ensureTempDirectoryExists(tempDirectory), name.substring(prefix.length()));
                if (!tempFile.getCanonicalFile().toPath().startsWith(tempDirectory.getCanonicalFile().toPath())) {
                    throw new IllegalStateException("Invalid extension " + name);
                }
                if (tempFile.createNewFile()) {
                    tempFile.deleteOnExit();
                    ExtensionClassLoader.extractFile(jarFile, jarEntry, tempFile);
                    ExtensionClassLoader.addFileUrl(extensions, tempFile);
                    continue;
                }
                System.err.println("Failed to create temp file " + tempFile);
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to open embedded extensions " + ex.getMessage());
        }
    }

    private static File ensureTempDirectoryExists(File tempDirectory) throws IOException {
        if (tempDirectory == null) {
            tempDirectory = Files.createTempDirectory("otel-extensions", new FileAttribute[0]).toFile();
            tempDirectory.deleteOnExit();
        }
        return tempDirectory;
    }

    private static URLClassLoader getDelegate(ClassLoader parent, URL extensionUrl, boolean isSecurityManagerSupportEnabled) {
        return new ExtensionClassLoader(extensionUrl, parent, isSecurityManagerSupportEnabled);
    }

    static List<URL> parseLocation(@Nullable String locationName, File javaagentFile) {
        if (locationName == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> result = new ArrayList<URL>();
        for (String location : locationName.split(",")) {
            ExtensionClassLoader.parseLocation(location, javaagentFile, result);
        }
        return result;
    }

    private static void parseLocation(String locationName, File javaagentFile, List<URL> locations) {
        File[] files;
        if (locationName.isEmpty()) {
            return;
        }
        File location = new File(locationName);
        if (ExtensionClassLoader.isJar(location)) {
            ExtensionClassLoader.addFileUrl(locations, location);
        } else if (location.isDirectory() && (files = location.listFiles(ExtensionClassLoader::isJar)) != null) {
            for (File file : files) {
                if (!ExtensionClassLoader.isJar(file) || file.getAbsolutePath().equals(javaagentFile.getAbsolutePath())) continue;
                ExtensionClassLoader.addFileUrl(locations, file);
            }
        }
    }

    private static boolean isJar(File f) {
        return f.isFile() && f.getName().endsWith(".jar");
    }

    private static void addFileUrl(List<URL> result, File file) {
        try {
            if (Context.class.getName().contains(".shaded.")) {
                URL wrappedUrl = new URL("otel", null, -1, "/", new RemappingUrlStreamHandler(file));
                result.add(wrappedUrl);
            } else {
                result.add(file.toURI().toURL());
            }
        }
        catch (MalformedURLException ignored) {
            System.err.println("Ignoring " + file);
        }
    }

    private static void extractFile(JarFile jarFile, JarEntry jarEntry, File outputFile) throws IOException {
        try (InputStream in = jarFile.getInputStream(jarEntry);
             ReadableByteChannel rbc = Channels.newChannel(in);
             FileOutputStream fos = new FileOutputStream(outputFile);){
            fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
        }
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        if (this.isSecurityManagerSupportEnabled) {
            Permissions permissions = new Permissions();
            permissions.add(new AllPermission());
            return permissions;
        }
        return super.getPermissions(codesource);
    }

    private ExtensionClassLoader(URL url, ClassLoader parent, boolean isSecurityManagerSupportEnabled) {
        super(new URL[]{url}, parent);
        this.isSecurityManagerSupportEnabled = isSecurityManagerSupportEnabled;
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

