/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.matcher;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.extension.muzzle.ClassRef;
import io.opentelemetry.javaagent.extension.muzzle.FieldRef;
import io.opentelemetry.javaagent.extension.muzzle.MethodRef;
import io.opentelemetry.javaagent.extension.muzzle.Source;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.Mismatch;
import io.opentelemetry.javaagent.tooling.muzzle.matcher.ReferenceMatcher;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.bytebuddy.dynamic.ClassFileLocator;

public final class MuzzleGradlePluginUtil {
    private static final String INDENT = "  ";

    public static void assertInstrumentationMuzzled(ClassLoader agentClassLoader, ClassLoader userClassLoader, boolean assertPass) throws Exception {
        int validatedModulesCount = 0;
        for (InstrumentationModule instrumentationModule : ServiceLoader.load(InstrumentationModule.class, agentClassLoader)) {
            boolean passed;
            ReferenceMatcher muzzle = new ReferenceMatcher(instrumentationModule.getMuzzleHelperClassNames(), instrumentationModule.getMuzzleReferences(), arg_0 -> ((InstrumentationModule)instrumentationModule).isHelperClass(arg_0));
            List<Mismatch> mismatches = muzzle.getMismatchedReferenceSources(userClassLoader);
            boolean classLoaderMatch = instrumentationModule.classLoaderMatcher().matches((Object)userClassLoader);
            boolean bl = passed = mismatches.isEmpty() && classLoaderMatch;
            if (passed && !assertPass) {
                System.err.println("MUZZLE PASSED " + instrumentationModule.getClass().getSimpleName() + " BUT FAILURE WAS EXPECTED");
                throw new IllegalStateException("Instrumentation unexpectedly passed Muzzle validation");
            }
            if (!passed && assertPass) {
                System.err.println("FAILED MUZZLE VALIDATION: " + instrumentationModule.getClass().getName() + " mismatches:");
                if (!classLoaderMatch) {
                    System.err.println("-- classloader mismatch");
                }
                for (Mismatch mismatch : mismatches) {
                    System.err.println("-- " + mismatch);
                }
                throw new IllegalStateException("Instrumentation failed Muzzle validation");
            }
            ++validatedModulesCount;
        }
        if (assertPass) {
            for (InstrumentationModule instrumentationModule : ServiceLoader.load(InstrumentationModule.class, agentClassLoader)) {
                try {
                    List allHelperClasses = instrumentationModule.getMuzzleHelperClassNames();
                    if (allHelperClasses.isEmpty()) continue;
                    new HelperInjector(MuzzleGradlePluginUtil.class.getSimpleName(), MuzzleGradlePluginUtil.createHelperMap(allHelperClasses, agentClassLoader)).transform(null, null, userClassLoader, null);
                }
                catch (RuntimeException e) {
                    System.err.println("FAILED HELPER INJECTION. Are Helpers being injected in the correct order?");
                    throw e;
                }
            }
        }
        if (validatedModulesCount == 0) {
            String errorMessage = "Did not found any InstrumentationModule to validate!";
            System.err.println(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    private static Map<String, byte[]> createHelperMap(Collection<String> helperClassNames, ClassLoader agentClassLoader) throws IOException {
        LinkedHashMap<String, byte[]> helperMap = new LinkedHashMap<String, byte[]>(helperClassNames.size());
        for (String helperName : helperClassNames) {
            ClassFileLocator locator = ClassFileLocator.ForClassLoader.of((ClassLoader)agentClassLoader);
            byte[] classBytes = locator.locate(helperName).resolve();
            helperMap.put(helperName, classBytes);
        }
        return helperMap;
    }

    public static void printMuzzleReferences(ClassLoader instrumentationClassLoader) {
        for (InstrumentationModule instrumentationModule : ServiceLoader.load(InstrumentationModule.class, instrumentationClassLoader)) {
            try {
                System.out.println(instrumentationModule.getClass().getName());
                for (ClassRef ref : instrumentationModule.getMuzzleReferences().values()) {
                    System.out.print(MuzzleGradlePluginUtil.prettyPrint(ref));
                }
            }
            catch (RuntimeException e) {
                String message = "Unexpected exception printing references for " + instrumentationModule.getClass().getName();
                System.out.println(message);
                throw new IllegalStateException(message, e);
            }
        }
    }

    private static String prettyPrint(ClassRef ref) {
        StringBuilder builder = new StringBuilder(INDENT).append(ref).append(System.lineSeparator());
        if (!ref.getSources().isEmpty()) {
            builder.append(INDENT).append(INDENT).append("Sources:").append(System.lineSeparator());
            for (Source source : ref.getSources()) {
                builder.append(INDENT).append(INDENT).append(INDENT).append("at: ").append(source).append(System.lineSeparator());
            }
        }
        for (FieldRef field : ref.getFields()) {
            builder.append(INDENT).append(INDENT).append(field).append(System.lineSeparator());
        }
        for (MethodRef method : ref.getMethods()) {
            builder.append(INDENT).append(INDENT).append(method).append(System.lineSeparator());
        }
        return builder.toString();
    }

    private MuzzleGradlePluginUtil() {
    }
}

