/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.OpenTelemetrySdkAccess;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.common.CompletableResultCode;
import java.util.Arrays;

public final class OpenTelemetryInstaller {
    public static AutoConfiguredOpenTelemetrySdk installOpenTelemetrySdk(ClassLoader extensionClassLoader) {
        AutoConfiguredOpenTelemetrySdk autoConfiguredSdk = AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal(true).setServiceClassLoader(extensionClassLoader).build();
        OpenTelemetrySdk sdk = autoConfiguredSdk.getOpenTelemetrySdk();
        OpenTelemetrySdkAccess.internalSetForceFlush((timeout, unit) -> {
            CompletableResultCode traceResult = sdk.getSdkTracerProvider().forceFlush();
            CompletableResultCode metricsResult = sdk.getSdkMeterProvider().forceFlush();
            CompletableResultCode logsResult = sdk.getSdkLoggerProvider().forceFlush();
            CompletableResultCode.ofAll(Arrays.asList(traceResult, metricsResult, logsResult)).join((long)timeout, unit);
        });
        return autoConfiguredSdk;
    }

    private OpenTelemetryInstaller() {
    }
}

