/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.ignore;

import com.google.auto.service.AutoService;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesConfigurer;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import java.util.Collections;
import java.util.List;

@AutoService(value={IgnoredTypesConfigurer.class})
public class UserExcludedClassesConfigurer
implements IgnoredTypesConfigurer {
    static final String EXCLUDED_CLASSES_CONFIG = "otel.javaagent.exclude-classes";

    public void configure(IgnoredTypesBuilder builder, ConfigProperties config) {
        List excludedClasses = config.getList(EXCLUDED_CLASSES_CONFIG, Collections.emptyList());
        for (String excludedClass : excludedClasses) {
            if ((excludedClass = excludedClass.trim()).endsWith("*")) {
                excludedClass = excludedClass.substring(0, excludedClass.length() - 1);
            }
            builder.ignoreClass(excludedClass);
        }
    }
}

