/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.extension.matcher.NameMatchers;
import io.opentelemetry.javaagent.extension.spi.AgentExtension;
import io.opentelemetry.javaagent.instrumentation.api.SafeServiceLoader;
import io.opentelemetry.javaagent.instrumentation.api.internal.BootstrapPackagePrefixesHolder;
import io.opentelemetry.javaagent.spi.BootstrapPackagesProvider;
import io.opentelemetry.javaagent.spi.ComponentInstaller;
import io.opentelemetry.javaagent.spi.IgnoreMatcherProvider;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import io.opentelemetry.javaagent.tooling.Constants;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.LoggingConfigurer;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.VersionLogger;
import io.opentelemetry.javaagent.tooling.config.ConfigInitializer;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.matcher.GlobalClassloaderIgnoresMatcher;
import io.opentelemetry.javaagent.tooling.matcher.GlobalIgnoresMatcher;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInstaller {
    private static final Logger log;
    private static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    private static final String EXCLUDED_CLASSES_CONFIG = "otel.javaagent.exclude-classes";
    private static final String FORCE_SYNCHRONOUS_COMPONENT_INSTALLER_CONFIG = "otel.javaagent.experimental.force-synchronous-component-installers";
    private static final String ADDITIONAL_LIBRARY_IGNORES_ENABLED = "otel.javaagent.testing.additional-library-ignores.enabled";
    private static final Map<String, List<Runnable>> CLASS_LOAD_CALLBACKS;
    private static volatile Instrumentation INSTRUMENTATION;

    public static Instrumentation getInstrumentation() {
        return INSTRUMENTATION;
    }

    public static void installBytebuddyAgent(Instrumentation inst) {
        AgentInstaller.logVersionInfo();
        Config config = Config.get();
        if (config.getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            Iterable<ComponentInstaller> componentInstallers = AgentInstaller.loadComponentProviders();
            AgentInstaller.installBytebuddyAgent(inst, componentInstallers);
        } else {
            log.debug("Tracing is disabled, not installing instrumentations.");
        }
    }

    public static ResettableClassFileTransformer installBytebuddyAgent(Instrumentation inst, Iterable<ComponentInstaller> componentInstallers) {
        Config config = Config.get();
        AgentInstaller.installComponentsBeforeByteBuddy(componentInstallers, config);
        INSTRUMENTATION = inst;
        FieldBackedProvider.resetContextMatchers();
        IgnoreMatcherProvider ignoreMatcherProvider = AgentInstaller.loadIgnoreMatcherProvider();
        log.debug("Ignore matcher provider {} will be used", (Object)ignoreMatcherProvider.getClass().getName());
        AgentBuilder.Ignored ignoredAgentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.DescriptionStrategy)AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with((AgentBuilder.PoolStrategy)AgentTooling.poolStrategy()).with((AgentBuilder.Listener)new ClassLoadListener()).with((AgentBuilder.LocationStrategy)AgentTooling.locationStrategy()).ignore((ElementMatcher)ElementMatchers.any(), GlobalClassloaderIgnoresMatcher.skipClassLoader(ignoreMatcherProvider));
        ignoredAgentBuilder = (AgentBuilder.Ignored)ignoredAgentBuilder.or(GlobalIgnoresMatcher.globalIgnoresMatcher(config.getBooleanProperty(ADDITIONAL_LIBRARY_IGNORES_ENABLED, true), ignoreMatcherProvider));
        AgentBuilder.Ignored agentBuilder = ignoredAgentBuilder = (AgentBuilder.Ignored)ignoredAgentBuilder.or(AgentInstaller.matchesConfiguredExcludes());
        if (log.isDebugEnabled()) {
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.RedefinitionStrategy.Listener)new RedefinitionLoggingListener()).with((AgentBuilder.Listener)new TransformLoggingListener());
        }
        int numberOfLoadedExtensions = 0;
        for (AgentExtension agentExtension : AgentInstaller.loadAgentExtensions()) {
            log.debug("Loading extension {} [class {}]", (Object)agentExtension.extensionName(), (Object)agentExtension.getClass().getName());
            try {
                agentBuilder = agentExtension.extend((AgentBuilder)agentBuilder);
                ++numberOfLoadedExtensions;
            }
            catch (Exception | LinkageError e) {
                log.error("Unable to load extension {} [class {}]", new Object[]{agentExtension.extensionName(), agentExtension.getClass().getName(), e});
            }
        }
        log.debug("Installed {} extension(s)", (Object)numberOfLoadedExtensions);
        ResettableClassFileTransformer resettableClassFileTransformer = agentBuilder.installOn(inst);
        AgentInstaller.installComponentsAfterByteBuddy(componentInstallers, config);
        return resettableClassFileTransformer;
    }

    private static void installComponentsBeforeByteBuddy(Iterable<ComponentInstaller> componentInstallers, Config config) {
        Thread.currentThread().setContextClassLoader(AgentInstaller.class.getClassLoader());
        for (ComponentInstaller componentInstaller : componentInstallers) {
            componentInstaller.beforeByteBuddyAgent(config);
        }
    }

    private static void installComponentsAfterByteBuddy(Iterable<ComponentInstaller> componentInstallers, Config config) {
        boolean shouldForceSynchronousComponentInstallerCalls = Config.get().getBooleanProperty(FORCE_SYNCHRONOUS_COMPONENT_INSTALLER_CONFIG, false);
        if (!shouldForceSynchronousComponentInstallerCalls && AgentInitializer.isJavaBefore9() && AgentInstaller.isAppUsingCustomLogManager()) {
            log.debug("Custom JUL LogManager detected: delaying ComponentInstaller#afterByteBuddyAgent() calls");
            AgentInstaller.registerClassLoadCallback("java.util.logging.LogManager", new InstallComponentAfterByteBuddyCallback(config, componentInstallers));
        } else {
            for (ComponentInstaller componentInstaller : componentInstallers) {
                componentInstaller.afterByteBuddyAgent(config);
            }
        }
    }

    private static Iterable<ComponentInstaller> loadComponentProviders() {
        return ServiceLoader.load(ComponentInstaller.class, AgentInstaller.class.getClassLoader());
    }

    private static IgnoreMatcherProvider loadIgnoreMatcherProvider() {
        ServiceLoader<IgnoreMatcherProvider> ignoreMatcherProviders = ServiceLoader.load(IgnoreMatcherProvider.class, AgentInstaller.class.getClassLoader());
        Iterator<IgnoreMatcherProvider> iterator = ignoreMatcherProviders.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return new NoopIgnoreMatcherProvider();
    }

    private static List<AgentExtension> loadAgentExtensions() {
        return SafeServiceLoader.load(AgentExtension.class, (ClassLoader)AgentInstaller.class.getClassLoader()).stream().sorted(Comparator.comparingInt(AgentExtension::order)).collect(Collectors.toList());
    }

    private static void addByteBuddyRawSetting() {
        String savedPropertyValue = System.getProperty("net.bytebuddy.raw");
        try {
            System.setProperty("net.bytebuddy.raw", "true");
            boolean rawTypes = TypeDescription.AbstractBase.RAW_TYPES;
            if (!rawTypes) {
                log.debug("Too late to enable {}", (Object)"net.bytebuddy.raw");
            }
        }
        finally {
            if (savedPropertyValue == null) {
                System.clearProperty("net.bytebuddy.raw");
            } else {
                System.setProperty("net.bytebuddy.raw", savedPropertyValue);
            }
        }
    }

    private static ElementMatcher.Junction<Object> matchesConfiguredExcludes() {
        List excludedClasses = Config.get().getListProperty(EXCLUDED_CLASSES_CONFIG);
        ElementMatcher.Junction matcher = ElementMatchers.none();
        ArrayList<String> literals = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String excludedClass : excludedClasses) {
            if ((excludedClass = excludedClass.trim()).endsWith("*")) {
                prefixes.add(excludedClass.substring(0, excludedClass.length() - 1));
                continue;
            }
            literals.add(excludedClass);
        }
        if (!literals.isEmpty()) {
            matcher = matcher.or((ElementMatcher)NameMatchers.namedOneOf(literals));
        }
        for (String prefix : prefixes) {
            matcher = matcher.or((ElementMatcher)ElementMatchers.nameStartsWith((String)prefix));
        }
        return matcher;
    }

    private static List<String> loadBootstrapPackagePrefixes() {
        ArrayList<String> bootstrapPackages = new ArrayList<String>(Arrays.asList(Constants.BOOTSTRAP_PACKAGE_PREFIXES));
        List bootstrapPackagesProviders = SafeServiceLoader.load(BootstrapPackagesProvider.class, (ClassLoader)AgentInstaller.class.getClassLoader());
        for (BootstrapPackagesProvider provider : bootstrapPackagesProviders) {
            List packagePrefixes = provider.getPackagePrefixes();
            log.debug("Loaded bootstrap package prefixes from {}: {}", (Object)provider.getClass().getName(), (Object)packagePrefixes);
            bootstrapPackages.addAll(packagePrefixes);
        }
        return bootstrapPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoadCallback(String className, Runnable callback) {
        Map<String, List<Runnable>> map = CLASS_LOAD_CALLBACKS;
        synchronized (map) {
            List callbacks = CLASS_LOAD_CALLBACKS.computeIfAbsent(className, k -> new ArrayList());
            callbacks.add(callback);
        }
    }

    private static boolean isAppUsingCustomLogManager() {
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            log.debug("Found JBoss: {}; assuming app is using custom LogManager", (Object)jbossHome);
            return true;
        }
        String customLogManager = System.getProperty("java.util.logging.manager");
        if (customLogManager != null) {
            log.debug("Detected custom LogManager configuration: java.util.logging.manager={}", (Object)customLogManager);
            boolean onSysClasspath = ClassLoader.getSystemResource(Utils.getResourceName(customLogManager)) != null;
            log.debug("Class {} is on system classpath: {}delaying ComponentInstaller#afterByteBuddyAgent()", (Object)customLogManager, (Object)(onSysClasspath ? "not " : ""));
            return !onSysClasspath;
        }
        return false;
    }

    private static void logVersionInfo() {
        VersionLogger.logAllVersions();
        log.debug(AgentInstaller.class.getName() + " loaded on " + AgentInstaller.class.getClassLoader());
    }

    private AgentInstaller() {
    }

    static {
        CLASS_LOAD_CALLBACKS = new HashMap<String, List<Runnable>>();
        LoggingConfigurer.configureLogger();
        log = LoggerFactory.getLogger(AgentInstaller.class);
        AgentInstaller.addByteBuddyRawSetting();
        BootstrapPackagePrefixesHolder.setBoostrapPackagePrefixes(AgentInstaller.loadBootstrapPackagePrefixes());
        ConfigInitializer.initialize();
        Proxy.class.getName();
    }

    private static class NoopIgnoreMatcherProvider
    implements IgnoreMatcherProvider {
        private NoopIgnoreMatcherProvider() {
        }

        public IgnoreMatcherProvider.Result classloader(ClassLoader classLoader) {
            return IgnoreMatcherProvider.Result.DEFAULT;
        }

        public IgnoreMatcherProvider.Result type(TypeDescription target) {
            return IgnoreMatcherProvider.Result.DEFAULT;
        }
    }

    private static class RedefinitionDiscoveryStrategy
    implements AgentBuilder.RedefinitionStrategy.DiscoveryStrategy {
        private static final AgentBuilder.RedefinitionStrategy.DiscoveryStrategy delegate = AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE;

        private RedefinitionDiscoveryStrategy() {
        }

        public Iterable<Iterable<Class<?>>> resolve(Instrumentation instrumentation) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(delegate.resolve(instrumentation)).map(this::filterClasses).iterator();
        }

        private Iterable<Class<?>> filterClasses(Iterable<Class<?>> classes) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(classes).filter(c -> !RedefinitionDiscoveryStrategy.isIgnored(c)).iterator();
        }

        private static <T> Stream<T> streamOf(Iterable<T> iterable) {
            return StreamSupport.stream(iterable.spliterator(), false);
        }

        private static boolean isIgnored(Class<?> c) {
            ClassLoader cl = c.getClassLoader();
            if (cl != null && cl.getClass() == AgentClassLoader.class) {
                return true;
            }
            return HelperInjector.isInjectedClass(c);
        }
    }

    private static class ClassLoadListener
    implements AgentBuilder.Listener {
        private ClassLoadListener() {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b, DynamicType dynamicType) {
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onError(String s, ClassLoader classLoader, JavaModule javaModule, boolean b, Throwable throwable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
            Map map = CLASS_LOAD_CALLBACKS;
            synchronized (map) {
                List callbacks = (List)CLASS_LOAD_CALLBACKS.get(typeName);
                if (callbacks != null) {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                }
            }
        }
    }

    private static class InstallComponentAfterByteBuddyCallback
    implements Runnable {
        private final Iterable<ComponentInstaller> componentInstallers;
        private final Config config;

        private InstallComponentAfterByteBuddyCallback(Config config, Iterable<ComponentInstaller> componentInstallers) {
            this.componentInstallers = componentInstallers;
            this.config = config;
        }

        @Override
        public void run() {
            Thread thread = new Thread(this::runComponentInstallers);
            thread.setName("agent-component-installers");
            thread.setDaemon(true);
            thread.start();
        }

        private void runComponentInstallers() {
            for (ComponentInstaller componentInstaller : this.componentInstallers) {
                try {
                    componentInstaller.afterByteBuddyAgent(this.config);
                }
                catch (Exception e) {
                    log.error("Failed to execute {}", (Object)componentInstaller.getClass().getName(), (Object)e);
                }
            }
        }
    }

    static class TransformLoggingListener
    implements AgentBuilder.Listener {
        private static final TransformSafeLogger log = TransformSafeLogger.getLogger(TransformLoggingListener.class);

        TransformLoggingListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to handle {} for transformation on classloader {}", typeName, classLoader, throwable);
            }
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            log.debug("Transformed {} -- {}", (Object)typeDescription.getName(), (Object)classLoader);
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }
    }

    static class RedefinitionLoggingListener
    implements AgentBuilder.RedefinitionStrategy.Listener {
        private static final Logger log = LoggerFactory.getLogger(RedefinitionLoggingListener.class);

        RedefinitionLoggingListener() {
        }

        public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
        }

        public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while retransforming " + batch.size() + " classes: " + batch, throwable);
            }
            return Collections.emptyList();
        }

        public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
        }
    }
}

