/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.opentelemetry.extension.noopapi.NoopOpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.bootstrap.BootstrapPackagePrefixesHolder;
import io.opentelemetry.javaagent.bootstrap.ClassFileTransformerHolder;
import io.opentelemetry.javaagent.bootstrap.DefineClassHelper;
import io.opentelemetry.javaagent.bootstrap.InstrumentedTaskClasses;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesConfigurer;
import io.opentelemetry.javaagent.tooling.AgentExtension;
import io.opentelemetry.javaagent.tooling.BeforeAgentListener;
import io.opentelemetry.javaagent.tooling.DefineClassHandler;
import io.opentelemetry.javaagent.tooling.ExposeAgentBootstrapListener;
import io.opentelemetry.javaagent.tooling.ExtensionClassLoader;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.OpenTelemetryInstaller;
import io.opentelemetry.javaagent.tooling.SafeServiceLoader;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.UnsafeInitializer;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.VersionLogger;
import io.opentelemetry.javaagent.tooling.asyncannotationsupport.WeakRefAsyncOperationEndStrategies;
import io.opentelemetry.javaagent.tooling.bootstrap.BootstrapPackagesBuilderImpl;
import io.opentelemetry.javaagent.tooling.bootstrap.BootstrapPackagesConfigurer;
import io.opentelemetry.javaagent.tooling.config.AgentConfig;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredClassLoadersMatcher;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesBuilderImpl;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesMatcher;
import io.opentelemetry.javaagent.tooling.muzzle.AgentTooling;
import io.opentelemetry.javaagent.tooling.util.Trie;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;

public class AgentInstaller {
    private static final Logger logger = Logger.getLogger(AgentInstaller.class.getName());
    static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    static final String JAVAAGENT_NOOP_CONFIG = "otel.javaagent.experimental.use-noop-api";
    private static final String FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG = "otel.javaagent.experimental.force-synchronous-agent-listeners";
    private static final String STRICT_CONTEXT_STRESSOR_MILLIS = "otel.javaagent.testing.strict-context-stressor-millis";
    private static final Map<String, List<Runnable>> CLASS_LOAD_CALLBACKS = new HashMap<String, List<Runnable>>();

    public static void installBytebuddyAgent(Instrumentation inst, Config config) {
        AgentInstaller.addByteBuddyRawSetting();
        Integer strictContextStressorMillis = Integer.getInteger(STRICT_CONTEXT_STRESSOR_MILLIS);
        if (strictContextStressorMillis != null) {
            ContextStorage.addWrapper(storage -> new StrictContextStressor((ContextStorage)storage, strictContextStressorMillis));
        }
        AgentInstaller.logVersionInfo();
        if (config.getBoolean(JAVAAGENT_ENABLED_CONFIG, true)) {
            AgentInstaller.setupUnsafe(inst);
            List<AgentListener> agentListeners = SafeServiceLoader.loadOrdered(AgentListener.class);
            AgentInstaller.installBytebuddyAgent(inst, config, agentListeners);
        } else {
            logger.fine("Tracing is disabled, not installing instrumentations.");
        }
    }

    private static void installBytebuddyAgent(Instrumentation inst, Config config, Iterable<AgentListener> agentListeners) {
        WeakRefAsyncOperationEndStrategies.initialize();
        EmbeddedInstrumentationProperties.setPropertiesLoader((ClassLoader)AgentInitializer.getExtensionsClassLoader());
        AgentInstaller.setBootstrapPackages(config);
        AgentInstaller.setDefineClassHandler();
        AutoConfiguredOpenTelemetrySdk autoConfiguredSdk = null;
        if (config.getBoolean(JAVAAGENT_NOOP_CONFIG, false)) {
            logger.info("Tracing and metrics are disabled because noop is enabled.");
            GlobalOpenTelemetry.set((OpenTelemetry)NoopOpenTelemetry.getInstance());
        } else {
            autoConfiguredSdk = OpenTelemetryInstaller.installOpenTelemetrySdk(config);
        }
        if (autoConfiguredSdk != null) {
            AgentInstaller.runBeforeAgentListeners(agentListeners, config, autoConfiguredSdk);
        }
        AgentBuilder agentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.DescriptionStrategy)AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with(AgentTooling.poolStrategy()).with((AgentBuilder.Listener)new ClassLoadListener()).with((AgentBuilder.LocationStrategy)AgentTooling.locationStrategy());
        if (JavaModule.isSupported()) {
            agentBuilder = agentBuilder.with((AgentBuilder.Listener)new ExposeAgentBootstrapListener(inst));
        }
        agentBuilder = AgentInstaller.configureIgnoredTypes(config, agentBuilder);
        if (AgentConfig.get().isDebugModeEnabled()) {
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.RedefinitionStrategy.Listener)new RedefinitionLoggingListener()).with((AgentBuilder.Listener)new TransformLoggingListener());
        }
        int numberOfLoadedExtensions = 0;
        for (AgentExtension agentExtension : SafeServiceLoader.loadOrdered(AgentExtension.class)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Loading extension {0} [class {1}]", new Object[]{agentExtension.extensionName(), agentExtension.getClass().getName()});
            }
            try {
                agentBuilder = agentExtension.extend(agentBuilder);
                ++numberOfLoadedExtensions;
            }
            catch (Exception | LinkageError e) {
                logger.log(Level.SEVERE, "Unable to load extension " + agentExtension.extensionName() + " [class " + agentExtension.getClass().getName() + "]", e);
            }
        }
        logger.log(Level.FINE, "Installed {0} extension(s)", numberOfLoadedExtensions);
        ResettableClassFileTransformer resettableClassFileTransformer = agentBuilder.installOn(inst);
        ClassFileTransformerHolder.setClassFileTransformer((ClassFileTransformer)resettableClassFileTransformer);
        if (autoConfiguredSdk != null) {
            AgentInstaller.runAfterAgentListeners(agentListeners, config, autoConfiguredSdk);
        }
    }

    private static void setupUnsafe(Instrumentation inst) {
        try {
            UnsafeInitializer.initialize((Instrumentation)inst, (ClassLoader)AgentInstaller.class.getClassLoader());
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            // empty catch block
        }
    }

    private static void setBootstrapPackages(Config config) {
        BootstrapPackagesBuilderImpl builder = new BootstrapPackagesBuilderImpl();
        for (BootstrapPackagesConfigurer configurer : SafeServiceLoader.load(BootstrapPackagesConfigurer.class)) {
            configurer.configure(config, builder);
        }
        BootstrapPackagePrefixesHolder.setBoostrapPackagePrefixes(builder.build());
    }

    private static void setDefineClassHandler() {
        DefineClassHelper.internalSetHandler((DefineClassHelper.Handler)DefineClassHandler.INSTANCE);
    }

    private static void runBeforeAgentListeners(Iterable<AgentListener> agentListeners, Config config, AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        for (AgentListener agentListener : agentListeners) {
            agentListener.beforeAgent(config, autoConfiguredSdk);
        }
        for (BeforeAgentListener beforeAgentListener : SafeServiceLoader.loadOrdered(BeforeAgentListener.class)) {
            beforeAgentListener.beforeAgent(config, autoConfiguredSdk);
        }
    }

    private static AgentBuilder configureIgnoredTypes(Config config, AgentBuilder agentBuilder) {
        IgnoredTypesBuilderImpl builder = new IgnoredTypesBuilderImpl();
        for (IgnoredTypesConfigurer configurer : SafeServiceLoader.loadOrdered(IgnoredTypesConfigurer.class)) {
            configurer.configure(config, (IgnoredTypesBuilder)builder);
        }
        Trie<Boolean> ignoredTasksTrie = builder.buildIgnoredTasksTrie();
        InstrumentedTaskClasses.setIgnoredTaskClassesPredicate(ignoredTasksTrie::contains);
        return (AgentBuilder)((AgentBuilder.Ignored)agentBuilder.ignore((ElementMatcher)ElementMatchers.any(), (ElementMatcher)new IgnoredClassLoadersMatcher(builder.buildIgnoredClassLoadersTrie())).or((ElementMatcher)new IgnoredTypesMatcher(builder.buildIgnoredTypesTrie()))).or((typeDescription, classLoader, module, classBeingRedefined, protectionDomain) -> HelperInjector.isInjectedClass((ClassLoader)classLoader, (String)typeDescription.getName()));
    }

    private static void runAfterAgentListeners(Iterable<AgentListener> agentListeners, Config config, AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        boolean shouldForceSynchronousAgentListenersCalls = Config.get().getBoolean(FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG, false);
        boolean javaBefore9 = AgentInstaller.isJavaBefore9();
        if (!shouldForceSynchronousAgentListenersCalls && javaBefore9 && AgentInstaller.isAppUsingCustomLogManager()) {
            logger.fine("Custom JUL LogManager detected: delaying AgentListener#afterAgent() calls");
            AgentInstaller.registerClassLoadCallback("java.util.logging.LogManager", new DelayedAfterAgentCallback(config, agentListeners, autoConfiguredSdk));
        } else {
            if (javaBefore9) {
                LogManager.getLogManager();
            }
            for (AgentListener agentListener : agentListeners) {
                agentListener.afterAgent(config, autoConfiguredSdk);
            }
        }
    }

    private static boolean isJavaBefore9() {
        return System.getProperty("java.version").startsWith("1.");
    }

    private static void addByteBuddyRawSetting() {
        String savedPropertyValue = System.getProperty("net.bytebuddy.raw");
        try {
            System.setProperty("net.bytebuddy.raw", "true");
            boolean rawTypes = TypeDescription.AbstractBase.RAW_TYPES;
            if (!rawTypes) {
                logger.log(Level.FINE, "Too late to enable {0}", "net.bytebuddy.raw");
            }
        }
        finally {
            if (savedPropertyValue == null) {
                System.clearProperty("net.bytebuddy.raw");
            } else {
                System.setProperty("net.bytebuddy.raw", savedPropertyValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoadCallback(String className, Runnable callback) {
        Map<String, List<Runnable>> map = CLASS_LOAD_CALLBACKS;
        synchronized (map) {
            List callbacks = CLASS_LOAD_CALLBACKS.computeIfAbsent(className, k -> new ArrayList());
            callbacks.add(callback);
        }
    }

    private static boolean isAppUsingCustomLogManager() {
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            logger.log(Level.FINE, "Found JBoss: {0}; assuming app is using custom LogManager", jbossHome);
            return true;
        }
        String customLogManager = System.getProperty("java.util.logging.manager");
        if (customLogManager != null) {
            boolean onSysClasspath;
            logger.log(Level.FINE, "Detected custom LogManager configuration: java.util.logging.manager={0}", customLogManager);
            boolean bl = onSysClasspath = ClassLoader.getSystemResource(Utils.getResourceName(customLogManager)) != null;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Class {0} is on system classpath: {1}delaying AgentInstaller#afterAgent()", new Object[]{customLogManager, onSysClasspath ? "not " : ""});
            }
            return !onSysClasspath;
        }
        return false;
    }

    private static void logVersionInfo() {
        VersionLogger.logAllVersions();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "{0} loaded on {1}", new Object[]{AgentInstaller.class.getName(), AgentInstaller.class.getClassLoader()});
        }
    }

    private AgentInstaller() {
    }

    private static class RedefinitionDiscoveryStrategy
    implements AgentBuilder.RedefinitionStrategy.DiscoveryStrategy {
        private static final AgentBuilder.RedefinitionStrategy.DiscoveryStrategy delegate = AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE;

        private RedefinitionDiscoveryStrategy() {
        }

        public Iterable<Iterable<Class<?>>> resolve(Instrumentation instrumentation) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(delegate.resolve(instrumentation)).map(RedefinitionDiscoveryStrategy::filterClasses).iterator();
        }

        private static Iterable<Class<?>> filterClasses(Iterable<Class<?>> classes) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(classes).filter(c -> !RedefinitionDiscoveryStrategy.isIgnored(c)).iterator();
        }

        private static <T> Stream<T> streamOf(Iterable<T> iterable) {
            return StreamSupport.stream(iterable.spliterator(), false);
        }

        private static boolean isIgnored(Class<?> c) {
            ClassLoader cl = c.getClassLoader();
            if (cl instanceof AgentClassLoader || cl instanceof ExtensionClassLoader) {
                return true;
            }
            if (c.getName().startsWith("java.lang.ClassLoader$ByteBuddyAccessor$")) {
                return true;
            }
            return HelperInjector.isInjectedClass(c);
        }
    }

    private static class ClassLoadListener
    extends AgentBuilder.Listener.Adapter {
        private ClassLoadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
            Map map = CLASS_LOAD_CALLBACKS;
            synchronized (map) {
                List callbacks = (List)CLASS_LOAD_CALLBACKS.get(typeName);
                if (callbacks != null) {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                }
            }
        }
    }

    static class RedefinitionLoggingListener
    implements AgentBuilder.RedefinitionStrategy.Listener {
        private static final Logger logger = Logger.getLogger(RedefinitionLoggingListener.class.getName());

        RedefinitionLoggingListener() {
        }

        public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
        }

        public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Exception while retransforming " + batch.size() + " classes: " + batch, throwable);
            }
            return Collections.emptyList();
        }

        public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
        }
    }

    static class TransformLoggingListener
    extends AgentBuilder.Listener.Adapter {
        private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(TransformLoggingListener.class);

        TransformLoggingListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Failed to handle {0} for transformation on classloader {1}", new Object[]{typeName, classLoader}, throwable);
            }
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Transformed {0} -- {1}", new Object[]{typeDescription.getName(), classLoader});
            }
        }
    }

    private static class DelayedAfterAgentCallback
    implements Runnable {
        private final Iterable<AgentListener> agentListeners;
        private final Config config;
        private final AutoConfiguredOpenTelemetrySdk autoConfiguredSdk;

        private DelayedAfterAgentCallback(Config config, Iterable<AgentListener> agentListeners, AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
            this.agentListeners = agentListeners;
            this.config = config;
            this.autoConfiguredSdk = autoConfiguredSdk;
        }

        @Override
        public void run() {
            Thread thread = new Thread(this::runAgentListeners);
            thread.setName("delayed-agent-listeners");
            thread.setDaemon(true);
            thread.start();
        }

        private void runAgentListeners() {
            for (AgentListener agentListener : this.agentListeners) {
                try {
                    agentListener.afterAgent(this.config, this.autoConfiguredSdk);
                }
                catch (RuntimeException e) {
                    logger.log(Level.SEVERE, "Failed to execute " + agentListener.getClass().getName(), e);
                }
            }
        }
    }

    private static class StrictContextStressor
    implements ContextStorage,
    AutoCloseable {
        private final ContextStorage contextStorage;
        private final int sleepMillis;

        private StrictContextStressor(ContextStorage contextStorage, int sleepMillis) {
            this.contextStorage = contextStorage;
            this.sleepMillis = sleepMillis;
        }

        public Scope attach(Context toAttach) {
            return this.wrap(this.contextStorage.attach(toAttach));
        }

        @Nullable
        public Context current() {
            return this.contextStorage.current();
        }

        @Override
        public void close() throws Exception {
            if (this.contextStorage instanceof AutoCloseable) {
                ((AutoCloseable)this.contextStorage).close();
            }
        }

        private Scope wrap(Scope scope) {
            return () -> {
                try {
                    Thread.sleep(this.sleepMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                scope.close();
            };
        }
    }
}

