/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.DefineClassHelper;
import java.nio.charset.StandardCharsets;
import org.objectweb.asm.ClassReader;

public class DefineClassHandler
implements DefineClassHelper.Handler {
    public static final DefineClassHandler INSTANCE = new DefineClassHandler();
    private static final ThreadLocal<DefineClassContextImpl> defineClassContext = ThreadLocal.withInitial(() -> DefineClassContextImpl.access$200());

    private DefineClassHandler() {
    }

    public DefineClassHelper.Handler.DefineClassContext beforeDefineClass(ClassLoader classLoader, String className, byte[] classBytes, int offset, int length) {
        if (classBytes == null || classBytes.length == 40 && new String(classBytes, StandardCharsets.ISO_8859_1).startsWith("J9ROMCLASSCOOKIE")) {
            return null;
        }
        DefineClassContextImpl context = null;
        try {
            String[] interfaces;
            ClassReader cr = new ClassReader(classBytes, offset, length);
            String superName = cr.getSuperName();
            if (superName != null) {
                Class.forName(superName.replace('/', '.'), false, classLoader);
            }
            for (String interfaceName : interfaces = cr.getInterfaces()) {
                Class.forName(interfaceName.replace('/', '.'), false, classLoader);
            }
        }
        catch (Throwable throwable) {
            context = DefineClassContextImpl.enter(className);
        }
        return context;
    }

    public void afterDefineClass(DefineClassHelper.Handler.DefineClassContext context) {
        if (context != null) {
            context.exit();
        }
    }

    public static boolean isFailedClass(String className) {
        DefineClassContextImpl context = defineClassContext.get();
        return context.failedClassName != null && context.failedClassName.equals(className);
    }

    private static class DefineClassContextImpl
    implements DefineClassHelper.Handler.DefineClassContext {
        private static final DefineClassContextImpl NOP = new DefineClassContextImpl();
        private final DefineClassContextImpl previous;
        private final String failedClassName;

        private DefineClassContextImpl() {
            this.previous = null;
            this.failedClassName = null;
        }

        private DefineClassContextImpl(DefineClassContextImpl previous, String failedClassName) {
            this.previous = previous;
            this.failedClassName = failedClassName;
        }

        static DefineClassContextImpl enter(String failedClassName) {
            DefineClassContextImpl previous = (DefineClassContextImpl)defineClassContext.get();
            DefineClassContextImpl context = new DefineClassContextImpl(previous, failedClassName);
            defineClassContext.set(context);
            return context;
        }

        public void exit() {
            defineClassContext.set(this.previous);
        }
    }
}

