/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.context.Scope;
import io.opentelemetry.extension.noopapi.NoopOpenTelemetry;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.bootstrap.BootstrapPackagePrefixesHolder;
import io.opentelemetry.javaagent.bootstrap.ClassFileTransformerHolder;
import io.opentelemetry.javaagent.extension.AgentListener;
import io.opentelemetry.javaagent.extension.bootstrap.BootstrapPackagesBuilder;
import io.opentelemetry.javaagent.extension.bootstrap.BootstrapPackagesConfigurer;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesBuilder;
import io.opentelemetry.javaagent.extension.ignore.IgnoredTypesConfigurer;
import io.opentelemetry.javaagent.instrumentation.api.internal.InstrumentedTaskClasses;
import io.opentelemetry.javaagent.tooling.AgentExtension;
import io.opentelemetry.javaagent.tooling.ExposeAgentBootstrapListener;
import io.opentelemetry.javaagent.tooling.ExtensionClassLoader;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.LoggingConfigurer;
import io.opentelemetry.javaagent.tooling.OpenTelemetryInstaller;
import io.opentelemetry.javaagent.tooling.SafeServiceLoader;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.UnsafeInitializer;
import io.opentelemetry.javaagent.tooling.Utils;
import io.opentelemetry.javaagent.tooling.VersionLogger;
import io.opentelemetry.javaagent.tooling.asyncannotationsupport.WeakRefAsyncOperationEndStrategies;
import io.opentelemetry.javaagent.tooling.bootstrap.BootstrapPackagesBuilderImpl;
import io.opentelemetry.javaagent.tooling.config.ConfigInitializer;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredClassLoadersMatcher;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesBuilderImpl;
import io.opentelemetry.javaagent.tooling.ignore.IgnoredTypesMatcher;
import io.opentelemetry.javaagent.tooling.muzzle.AgentTooling;
import io.opentelemetry.javaagent.tooling.util.Trie;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInstaller {
    private static final Logger logger;
    static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    static final String JAVAAGENT_NOOP_CONFIG = "otel.javaagent.experimental.use-noop-api";
    private static final String FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG = "otel.javaagent.experimental.force-synchronous-agent-listeners";
    private static final String STRICT_CONTEXT_STRESSOR_MILLIS = "otel.javaagent.testing.strict-context-stressor-millis";
    private static final Map<String, List<Runnable>> CLASS_LOAD_CALLBACKS;

    public static void installBytebuddyAgent(Instrumentation inst) {
        AgentInstaller.logVersionInfo();
        Config config = Config.get();
        if (config.getBoolean(JAVAAGENT_ENABLED_CONFIG, true)) {
            AgentInstaller.setupUnsafe(inst);
            List<AgentListener> agentListeners = SafeServiceLoader.loadOrdered(AgentListener.class);
            AgentInstaller.installBytebuddyAgent(inst, agentListeners);
        } else {
            logger.debug("Tracing is disabled, not installing instrumentations.");
        }
    }

    public static ResettableClassFileTransformer installBytebuddyAgent(Instrumentation inst, Iterable<AgentListener> agentListeners) {
        WeakRefAsyncOperationEndStrategies.initialize();
        Config config = Config.get();
        AgentInstaller.setBootstrapPackages(config);
        AutoConfiguredOpenTelemetrySdk autoConfiguredSdk = null;
        if (config.getBoolean(JAVAAGENT_NOOP_CONFIG, false)) {
            logger.info("Tracing and metrics are disabled because noop is enabled.");
            GlobalOpenTelemetry.set((OpenTelemetry)NoopOpenTelemetry.getInstance());
        } else {
            autoConfiguredSdk = OpenTelemetryInstaller.installOpenTelemetrySdk(config);
        }
        if (autoConfiguredSdk != null) {
            AgentInstaller.runBeforeAgentListeners(agentListeners, config, autoConfiguredSdk);
        }
        AgentBuilder agentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.DescriptionStrategy)AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with((AgentBuilder.PoolStrategy)AgentTooling.poolStrategy()).with((AgentBuilder.Listener)new ClassLoadListener()).with((AgentBuilder.LocationStrategy)AgentTooling.locationStrategy((ClassLoader)Utils.getBootstrapProxy()));
        if (JavaModule.isSupported()) {
            agentBuilder = agentBuilder.with((AgentBuilder.Listener)new ExposeAgentBootstrapListener(inst));
        }
        agentBuilder = AgentInstaller.configureIgnoredTypes(config, agentBuilder);
        if (logger.isDebugEnabled()) {
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.RedefinitionStrategy.Listener)new RedefinitionLoggingListener()).with((AgentBuilder.Listener)new TransformLoggingListener());
        }
        int numberOfLoadedExtensions = 0;
        for (AgentExtension agentExtension : SafeServiceLoader.loadOrdered(AgentExtension.class)) {
            logger.debug("Loading extension {} [class {}]", (Object)agentExtension.extensionName(), (Object)agentExtension.getClass().getName());
            try {
                agentBuilder = agentExtension.extend(agentBuilder);
                ++numberOfLoadedExtensions;
            }
            catch (Exception | LinkageError e) {
                logger.error("Unable to load extension {} [class {}]", new Object[]{agentExtension.extensionName(), agentExtension.getClass().getName(), e});
            }
        }
        logger.debug("Installed {} extension(s)", (Object)numberOfLoadedExtensions);
        ResettableClassFileTransformer resettableClassFileTransformer = agentBuilder.installOn(inst);
        ClassFileTransformerHolder.setClassFileTransformer((ClassFileTransformer)resettableClassFileTransformer);
        if (autoConfiguredSdk != null) {
            AgentInstaller.runAfterAgentListeners(agentListeners, config, autoConfiguredSdk);
        }
        return resettableClassFileTransformer;
    }

    private static void setupUnsafe(Instrumentation inst) {
        try {
            UnsafeInitializer.initialize((Instrumentation)inst, (ClassLoader)AgentInstaller.class.getClassLoader());
        }
        catch (UnsupportedClassVersionError unsupportedClassVersionError) {
            // empty catch block
        }
    }

    private static void setBootstrapPackages(Config config) {
        BootstrapPackagesBuilderImpl builder = new BootstrapPackagesBuilderImpl();
        for (BootstrapPackagesConfigurer configurer : SafeServiceLoader.load(BootstrapPackagesConfigurer.class)) {
            configurer.configure(config, (BootstrapPackagesBuilder)builder);
        }
        BootstrapPackagePrefixesHolder.setBoostrapPackagePrefixes(builder.build());
    }

    private static void runBeforeAgentListeners(Iterable<AgentListener> agentListeners, Config config, AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        for (AgentListener agentListener : agentListeners) {
            agentListener.beforeAgent(config);
            agentListener.beforeAgent(config, autoConfiguredSdk);
        }
    }

    private static AgentBuilder configureIgnoredTypes(Config config, AgentBuilder agentBuilder) {
        IgnoredTypesBuilderImpl builder = new IgnoredTypesBuilderImpl();
        for (IgnoredTypesConfigurer configurer : SafeServiceLoader.loadOrdered(IgnoredTypesConfigurer.class)) {
            configurer.configure(config, (IgnoredTypesBuilder)builder);
        }
        Trie<Boolean> ignoredTasksTrie = builder.buildIgnoredTasksTrie();
        InstrumentedTaskClasses.setIgnoredTaskClassesPredicate(ignoredTasksTrie::contains);
        return (AgentBuilder)agentBuilder.ignore((ElementMatcher)ElementMatchers.any(), (ElementMatcher)new IgnoredClassLoadersMatcher(builder.buildIgnoredClassLoadersTrie())).or((ElementMatcher)new IgnoredTypesMatcher(builder.buildIgnoredTypesTrie()));
    }

    private static void runAfterAgentListeners(Iterable<AgentListener> agentListeners, Config config, AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
        boolean shouldForceSynchronousAgentListenersCalls = Config.get().getBoolean(FORCE_SYNCHRONOUS_AGENT_LISTENERS_CONFIG, false);
        if (!shouldForceSynchronousAgentListenersCalls && AgentInitializer.isJavaBefore9() && AgentInstaller.isAppUsingCustomLogManager()) {
            logger.debug("Custom JUL LogManager detected: delaying AgentListener#afterAgent() calls");
            AgentInstaller.registerClassLoadCallback("java.util.logging.LogManager", new DelayedAfterAgentCallback(config, agentListeners, autoConfiguredSdk));
        } else {
            for (AgentListener agentListener : agentListeners) {
                agentListener.afterAgent(config);
                agentListener.afterAgent(config, autoConfiguredSdk);
            }
        }
    }

    private static void addByteBuddyRawSetting() {
        String savedPropertyValue = System.getProperty("net.bytebuddy.raw");
        try {
            System.setProperty("net.bytebuddy.raw", "true");
            boolean rawTypes = TypeDescription.AbstractBase.RAW_TYPES;
            if (!rawTypes) {
                logger.debug("Too late to enable {}", (Object)"net.bytebuddy.raw");
            }
        }
        finally {
            if (savedPropertyValue == null) {
                System.clearProperty("net.bytebuddy.raw");
            } else {
                System.setProperty("net.bytebuddy.raw", savedPropertyValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoadCallback(String className, Runnable callback) {
        Map<String, List<Runnable>> map = CLASS_LOAD_CALLBACKS;
        synchronized (map) {
            List callbacks = CLASS_LOAD_CALLBACKS.computeIfAbsent(className, k -> new ArrayList());
            callbacks.add(callback);
        }
    }

    private static boolean isAppUsingCustomLogManager() {
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            logger.debug("Found JBoss: {}; assuming app is using custom LogManager", (Object)jbossHome);
            return true;
        }
        String customLogManager = System.getProperty("java.util.logging.manager");
        if (customLogManager != null) {
            logger.debug("Detected custom LogManager configuration: java.util.logging.manager={}", (Object)customLogManager);
            boolean onSysClasspath = ClassLoader.getSystemResource(Utils.getResourceName(customLogManager)) != null;
            logger.debug("Class {} is on system classpath: {}delaying AgentInstaller#afterAgent()", (Object)customLogManager, (Object)(onSysClasspath ? "not " : ""));
            return !onSysClasspath;
        }
        return false;
    }

    private static void logVersionInfo() {
        VersionLogger.logAllVersions();
        logger.debug("{} loaded on {}", (Object)AgentInstaller.class.getName(), (Object)AgentInstaller.class.getClassLoader());
    }

    private AgentInstaller() {
    }

    static {
        CLASS_LOAD_CALLBACKS = new HashMap<String, List<Runnable>>();
        LoggingConfigurer.configureLogger();
        logger = LoggerFactory.getLogger(AgentInstaller.class);
        AgentInstaller.addByteBuddyRawSetting();
        ConfigInitializer.initialize();
        Integer strictContextStressorMillis = Integer.getInteger(STRICT_CONTEXT_STRESSOR_MILLIS);
        if (strictContextStressorMillis != null) {
            ContextStorage.addWrapper(storage -> new StrictContextStressor((ContextStorage)storage, strictContextStressorMillis));
        }
    }

    private static class StrictContextStressor
    implements ContextStorage,
    AutoCloseable {
        private final ContextStorage contextStorage;
        private final int sleepMillis;

        private StrictContextStressor(ContextStorage contextStorage, int sleepMillis) {
            this.contextStorage = contextStorage;
            this.sleepMillis = sleepMillis;
        }

        public Scope attach(Context toAttach) {
            return this.wrap(this.contextStorage.attach(toAttach));
        }

        @Nullable
        public Context current() {
            return this.contextStorage.current();
        }

        @Override
        public void close() throws Exception {
            if (this.contextStorage instanceof AutoCloseable) {
                ((AutoCloseable)this.contextStorage).close();
            }
        }

        private Scope wrap(Scope scope) {
            return () -> {
                try {
                    Thread.sleep(this.sleepMillis);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                scope.close();
            };
        }
    }

    private static class RedefinitionDiscoveryStrategy
    implements AgentBuilder.RedefinitionStrategy.DiscoveryStrategy {
        private static final AgentBuilder.RedefinitionStrategy.DiscoveryStrategy delegate = AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE;

        private RedefinitionDiscoveryStrategy() {
        }

        public Iterable<Iterable<Class<?>>> resolve(Instrumentation instrumentation) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(delegate.resolve(instrumentation)).map(RedefinitionDiscoveryStrategy::filterClasses).iterator();
        }

        private static Iterable<Class<?>> filterClasses(Iterable<Class<?>> classes) {
            return () -> RedefinitionDiscoveryStrategy.streamOf(classes).filter(c -> !RedefinitionDiscoveryStrategy.isIgnored(c)).iterator();
        }

        private static <T> Stream<T> streamOf(Iterable<T> iterable) {
            return StreamSupport.stream(iterable.spliterator(), false);
        }

        private static boolean isIgnored(Class<?> c) {
            ClassLoader cl = c.getClassLoader();
            if (cl instanceof AgentClassLoader || cl instanceof ExtensionClassLoader) {
                return true;
            }
            if (c.getName().startsWith("java.lang.ClassLoader$ByteBuddyAccessor$")) {
                return true;
            }
            return HelperInjector.isInjectedClass(c);
        }
    }

    private static class ClassLoadListener
    extends AgentBuilder.Listener.Adapter {
        private ClassLoadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
            Map map = CLASS_LOAD_CALLBACKS;
            synchronized (map) {
                List callbacks = (List)CLASS_LOAD_CALLBACKS.get(typeName);
                if (callbacks != null) {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                }
            }
        }
    }

    private static class DelayedAfterAgentCallback
    implements Runnable {
        private final Iterable<AgentListener> agentListeners;
        private final Config config;
        private final AutoConfiguredOpenTelemetrySdk autoConfiguredSdk;

        private DelayedAfterAgentCallback(Config config, Iterable<AgentListener> agentListeners, AutoConfiguredOpenTelemetrySdk autoConfiguredSdk) {
            this.agentListeners = agentListeners;
            this.config = config;
            this.autoConfiguredSdk = autoConfiguredSdk;
        }

        @Override
        public void run() {
            Thread thread = new Thread(this::runAgentListeners);
            thread.setName("delayed-agent-listeners");
            thread.setDaemon(true);
            thread.start();
        }

        private void runAgentListeners() {
            for (AgentListener agentListener : this.agentListeners) {
                try {
                    agentListener.afterAgent(this.config);
                    agentListener.afterAgent(this.config, this.autoConfiguredSdk);
                }
                catch (RuntimeException e) {
                    logger.error("Failed to execute {}", (Object)agentListener.getClass().getName(), (Object)e);
                }
            }
        }
    }

    static class TransformLoggingListener
    extends AgentBuilder.Listener.Adapter {
        private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(TransformLoggingListener.class);

        TransformLoggingListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to handle {} for transformation on classloader {}", new Object[]{typeName, classLoader, throwable});
            }
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            logger.debug("Transformed {} -- {}", (Object)typeDescription.getName(), (Object)classLoader);
        }
    }

    static class RedefinitionLoggingListener
    implements AgentBuilder.RedefinitionStrategy.Listener {
        private static final Logger logger = LoggerFactory.getLogger(RedefinitionLoggingListener.class);

        RedefinitionLoggingListener() {
        }

        public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
        }

        public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception while retransforming {} classes: {}", new Object[]{batch.size(), batch, throwable});
            }
            return Collections.emptyList();
        }

        public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
        }
    }
}

