/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.matcher;

import io.opentelemetry.javaagent.tooling.muzzle.Reference;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.pool.TypePool;

public interface HelperReferenceWrapper {
    public boolean isAbstract();

    public boolean hasSuperTypes();

    public Stream<HelperReferenceWrapper> getSuperTypes();

    public Stream<Method> getMethods();

    public static class Factory {
        private final TypePool classpathPool;
        private final Map<String, Reference> helperReferences;

        public Factory(TypePool classpathPool, Map<String, Reference> helperReferences) {
            this.classpathPool = classpathPool;
            this.helperReferences = helperReferences;
        }

        public HelperReferenceWrapper create(Reference reference) {
            return new ReferenceType(reference);
        }

        private HelperReferenceWrapper create(String className) {
            TypePool.Resolution resolution = this.classpathPool.describe(className);
            if (resolution.isResolved()) {
                return new ClasspathType(resolution.resolve());
            }
            if (this.helperReferences.containsKey(className)) {
                return new ReferenceType(this.helperReferences.get(className));
            }
            throw new IllegalStateException("Missing class " + className);
        }

        private static final class ClasspathType
        implements HelperReferenceWrapper {
            private final TypeDescription type;

            private ClasspathType(TypeDescription type) {
                this.type = type;
            }

            @Override
            public boolean isAbstract() {
                return this.type.isAbstract();
            }

            @Override
            public boolean hasSuperTypes() {
                return this.hasActualSuperType() || this.type.getInterfaces().size() > 0;
            }

            private boolean hasActualSuperType() {
                return this.type.getSuperClass() != null;
            }

            @Override
            public Stream<HelperReferenceWrapper> getSuperTypes() {
                Stream<Object> superClass = Stream.empty();
                if (this.hasActualSuperType()) {
                    superClass = Stream.of(new ClasspathType(this.type.getSuperClass().asErasure()));
                }
                Stream<HelperReferenceWrapper> interfaces = this.type.getInterfaces().asErasures().stream().map(ClasspathType::new);
                return Stream.concat(superClass, interfaces);
            }

            @Override
            public Stream<Method> getMethods() {
                return this.type.getDeclaredMethods().stream().filter(this::isOverrideable).map(this::toMethod);
            }

            private boolean isOverrideable(MethodDescription.InDefinedShape method) {
                return !method.isStatic() && !method.isPrivate() && !method.isConstructor();
            }

            private Method toMethod(MethodDescription.InDefinedShape method) {
                return new Method(method.isAbstract(), this.type.getName(), method.getInternalName(), method.getDescriptor());
            }
        }

        private final class ReferenceType
        implements HelperReferenceWrapper {
            private final Reference reference;

            private ReferenceType(Reference reference) {
                this.reference = reference;
            }

            @Override
            public boolean isAbstract() {
                return this.reference.getFlags().contains(Reference.Flag.ManifestationFlag.ABSTRACT);
            }

            @Override
            public boolean hasSuperTypes() {
                return this.hasActualSuperType() || this.reference.getInterfaces().size() > 0;
            }

            @Override
            public Stream<HelperReferenceWrapper> getSuperTypes() {
                Stream<Object> superClass = Stream.empty();
                if (this.hasActualSuperType()) {
                    superClass = Stream.of(Factory.this.create(this.reference.getSuperName()));
                }
                Stream<HelperReferenceWrapper> interfaces = this.reference.getInterfaces().stream().map(x$0 -> Factory.this.create(x$0));
                return Stream.concat(superClass, interfaces);
            }

            private boolean hasActualSuperType() {
                return this.reference.getSuperName() != null;
            }

            @Override
            public Stream<Method> getMethods() {
                return this.reference.getMethods().stream().filter(this::isOverrideable).map(this::toMethod);
            }

            private boolean isOverrideable(Reference.Method method) {
                return !method.getFlags().contains(Reference.Flag.OwnershipFlag.STATIC) && !method.getFlags().contains(Reference.Flag.VisibilityFlag.PRIVATE) && !"<init>".equals(method.getName());
            }

            private Method toMethod(Reference.Method method) {
                return new Method(method.getFlags().contains(Reference.Flag.ManifestationFlag.ABSTRACT), this.reference.getClassName(), method.getName(), method.getDescriptor());
            }
        }
    }

    public static final class Method {
        private final boolean isAbstract;
        private final String declaringClass;
        private final String name;
        private final String descriptor;

        public Method(boolean isAbstract, String declaringClass, String name, String descriptor) {
            this.isAbstract = isAbstract;
            this.declaringClass = declaringClass;
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean isAbstract() {
            return this.isAbstract;
        }

        public String getDeclaringClass() {
            return this.declaringClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Method)) {
                return false;
            }
            Method other = (Method)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.descriptor, other.descriptor);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.descriptor);
        }
    }
}

