/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.common.collect.Iterables;
import io.opentelemetry.instrumentation.api.config.Config;
import io.opentelemetry.instrumentation.api.internal.BootstrapPackagePrefixesHolder;
import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.instrumentation.api.SafeServiceLoader;
import io.opentelemetry.javaagent.spi.BootstrapPackagesProvider;
import io.opentelemetry.javaagent.spi.ByteBuddyAgentCustomizer;
import io.opentelemetry.javaagent.spi.ComponentInstaller;
import io.opentelemetry.javaagent.spi.IgnoreMatcherProvider;
import io.opentelemetry.javaagent.tooling.AgentTooling;
import io.opentelemetry.javaagent.tooling.Constants;
import io.opentelemetry.javaagent.tooling.HelperInjector;
import io.opentelemetry.javaagent.tooling.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.LoggingConfigurer;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.VersionLogger;
import io.opentelemetry.javaagent.tooling.bytebuddy.matcher.NameMatchers;
import io.opentelemetry.javaagent.tooling.config.ConfigInitializer;
import io.opentelemetry.javaagent.tooling.context.FieldBackedProvider;
import io.opentelemetry.javaagent.tooling.matcher.GlobalClassloaderIgnoresMatcher;
import io.opentelemetry.javaagent.tooling.matcher.GlobalIgnoresMatcher;
import java.lang.instrument.Instrumentation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.agent.builder.ResettableClassFileTransformer;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInstaller {
    private static final Logger log;
    private static final String JAVAAGENT_ENABLED_CONFIG = "otel.javaagent.enabled";
    private static final String EXCLUDED_CLASSES_CONFIG = "otel.javaagent.exclude-classes";
    private static final String DISABLE_GLOBAL_LIBRARY_IGNORES_FOR_TEST = "internal.testing.disable.global.library.ignores";
    private static final Map<String, List<Runnable>> CLASS_LOAD_CALLBACKS;
    private static volatile Instrumentation INSTRUMENTATION;

    public static Instrumentation getInstrumentation() {
        return INSTRUMENTATION;
    }

    public static void installBytebuddyAgent(Instrumentation inst) {
        AgentInstaller.logVersionInfo();
        if (Config.get().getBooleanProperty(JAVAAGENT_ENABLED_CONFIG, true)) {
            Iterable<ComponentInstaller> componentInstallers = AgentInstaller.loadComponentProviders();
            AgentInstaller.installBytebuddyAgent(inst, componentInstallers);
        } else {
            log.debug("Tracing is disabled, not installing instrumentations.");
        }
    }

    public static ResettableClassFileTransformer installBytebuddyAgent(Instrumentation inst, Iterable<ComponentInstaller> componentInstallers) {
        AgentInstaller.installComponentsBeforeByteBuddy(componentInstallers);
        INSTRUMENTATION = inst;
        FieldBackedProvider.resetContextMatchers();
        IgnoreMatcherProvider ignoreMatcherProvider = AgentInstaller.loadIgnoreMatcherProvider();
        log.debug("Ignore matcher provider {} will be used", (Object)ignoreMatcherProvider.getClass().getName());
        AgentBuilder.Ignored ignoredAgentBuilder = new AgentBuilder.Default().disableClassFormatChanges().with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.DescriptionStrategy)AgentBuilder.DescriptionStrategy.Default.POOL_ONLY).with((AgentBuilder.PoolStrategy)AgentTooling.poolStrategy()).with((AgentBuilder.Listener)new ClassLoadListener()).with((AgentBuilder.LocationStrategy)AgentTooling.locationStrategy()).ignore((ElementMatcher)ElementMatchers.any(), GlobalClassloaderIgnoresMatcher.skipClassLoader(ignoreMatcherProvider));
        ignoredAgentBuilder = (AgentBuilder.Ignored)ignoredAgentBuilder.or(GlobalIgnoresMatcher.globalIgnoresMatcher(Config.get().getBooleanProperty(DISABLE_GLOBAL_LIBRARY_IGNORES_FOR_TEST, false), ignoreMatcherProvider));
        AgentBuilder.Ignored agentBuilder = ignoredAgentBuilder = (AgentBuilder.Ignored)ignoredAgentBuilder.or(AgentInstaller.matchesConfiguredExcludes());
        if (log.isDebugEnabled()) {
            agentBuilder = agentBuilder.with(AgentBuilder.RedefinitionStrategy.RETRANSFORMATION).with((AgentBuilder.RedefinitionStrategy.DiscoveryStrategy)new RedefinitionDiscoveryStrategy()).with((AgentBuilder.RedefinitionStrategy.Listener)new RedefinitionLoggingListener()).with((AgentBuilder.Listener)new TransformLoggingListener());
        }
        int numInstrumenters = 0;
        for (InstrumentationModule instrumentationModule : AgentInstaller.loadInstrumentationModules()) {
            log.debug("Loading instrumentation {}", (Object)instrumentationModule.getClass().getName());
            try {
                agentBuilder = instrumentationModule.instrument((AgentBuilder)agentBuilder);
                ++numInstrumenters;
            }
            catch (Exception | LinkageError e) {
                log.error("Unable to load instrumentation {}", (Object)instrumentationModule.getClass().getName(), (Object)e);
            }
        }
        agentBuilder = AgentInstaller.customizeByteBuddyAgent((AgentBuilder)agentBuilder);
        log.debug("Installed {} instrumenter(s)", (Object)numInstrumenters);
        ResettableClassFileTransformer resettableClassFileTransformer = agentBuilder.installOn(inst);
        AgentInstaller.installComponentsAfterByteBuddy(componentInstallers);
        return resettableClassFileTransformer;
    }

    private static void installComponentsBeforeByteBuddy(Iterable<ComponentInstaller> componentInstallers) {
        Thread.currentThread().setContextClassLoader(AgentInstaller.class.getClassLoader());
        for (ComponentInstaller componentInstaller : componentInstallers) {
            componentInstaller.beforeByteBuddyAgent();
        }
    }

    private static void installComponentsAfterByteBuddy(Iterable<ComponentInstaller> componentInstallers) {
        boolean appUsingCustomLogManager = AgentInstaller.isAppUsingCustomLogManager();
        if (AgentInstaller.isJavaBefore9WithJfr() && appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying Agent Tracer initialization.");
            AgentInstaller.registerClassLoadCallback("java.util.logging.LogManager", new InstallComponentAfterByteBuddyCallback(componentInstallers));
        } else {
            for (ComponentInstaller componentInstaller : componentInstallers) {
                componentInstaller.afterByteBuddyAgent();
            }
        }
    }

    private static AgentBuilder customizeByteBuddyAgent(AgentBuilder agentBuilder) {
        Iterable<ByteBuddyAgentCustomizer> agentCustomizers = AgentInstaller.loadByteBuddyAgentCustomizers();
        for (ByteBuddyAgentCustomizer agentCustomizer : agentCustomizers) {
            log.debug("Applying agent builder customizer {}", (Object)agentCustomizer.getClass().getName());
            agentBuilder = agentCustomizer.customize(agentBuilder);
        }
        return agentBuilder;
    }

    private static Iterable<ComponentInstaller> loadComponentProviders() {
        return ServiceLoader.load(ComponentInstaller.class, AgentInstaller.class.getClassLoader());
    }

    private static IgnoreMatcherProvider loadIgnoreMatcherProvider() {
        ServiceLoader<IgnoreMatcherProvider> ignoreMatcherProviders = ServiceLoader.load(IgnoreMatcherProvider.class, AgentInstaller.class.getClassLoader());
        Iterator<IgnoreMatcherProvider> iterator = ignoreMatcherProviders.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return new NoopIgnoreMatcherProvider();
    }

    private static Iterable<ByteBuddyAgentCustomizer> loadByteBuddyAgentCustomizers() {
        return ServiceLoader.load(ByteBuddyAgentCustomizer.class, AgentInstaller.class.getClassLoader());
    }

    private static List<InstrumentationModule> loadInstrumentationModules() {
        return SafeServiceLoader.load(InstrumentationModule.class, (ClassLoader)AgentInstaller.class.getClassLoader()).stream().sorted(Comparator.comparingInt(InstrumentationModule::getOrder)).collect(Collectors.toList());
    }

    private static void addByteBuddyRawSetting() {
        String savedPropertyValue = System.getProperty("net.bytebuddy.raw");
        try {
            System.setProperty("net.bytebuddy.raw", "true");
            boolean rawTypes = TypeDescription.AbstractBase.RAW_TYPES;
            if (!rawTypes) {
                log.debug("Too late to enable {}", (Object)"net.bytebuddy.raw");
            }
        }
        finally {
            if (savedPropertyValue == null) {
                System.clearProperty("net.bytebuddy.raw");
            } else {
                System.setProperty("net.bytebuddy.raw", savedPropertyValue);
            }
        }
    }

    private static ElementMatcher.Junction<Object> matchesConfiguredExcludes() {
        List excludedClasses = Config.get().getListProperty(EXCLUDED_CLASSES_CONFIG);
        ElementMatcher.Junction matcher = ElementMatchers.none();
        ArrayList<String> literals = new ArrayList<String>();
        ArrayList<String> prefixes = new ArrayList<String>();
        for (String excludedClass : excludedClasses) {
            if ((excludedClass = excludedClass.trim()).endsWith("*")) {
                prefixes.add(excludedClass.substring(0, excludedClass.length() - 1));
                continue;
            }
            literals.add(excludedClass);
        }
        if (!literals.isEmpty()) {
            matcher = matcher.or(NameMatchers.namedOneOf(literals));
        }
        for (String prefix : prefixes) {
            matcher = matcher.or((ElementMatcher)ElementMatchers.nameStartsWith((String)prefix));
        }
        return matcher;
    }

    private static List<String> loadBootstrapPackagePrefixes() {
        ArrayList<String> bootstrapPackages = new ArrayList<String>(Arrays.asList(Constants.BOOTSTRAP_PACKAGE_PREFIXES));
        List bootstrapPackagesProviders = SafeServiceLoader.load(BootstrapPackagesProvider.class, (ClassLoader)AgentInstaller.class.getClassLoader());
        for (BootstrapPackagesProvider provider : bootstrapPackagesProviders) {
            List packagePrefixes = provider.getPackagePrefixes();
            log.debug("Loaded bootstrap package prefixes from {}: {}", (Object)provider.getClass().getName(), (Object)packagePrefixes);
            bootstrapPackages.addAll(packagePrefixes);
        }
        return bootstrapPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClassLoadCallback(String className, Runnable callback) {
        Map<String, List<Runnable>> map = CLASS_LOAD_CALLBACKS;
        synchronized (map) {
            List callbacks = CLASS_LOAD_CALLBACKS.computeIfAbsent(className, k -> new ArrayList());
            callbacks.add(callback);
        }
    }

    private static boolean isAppUsingCustomLogManager() {
        String tracerCustomLogManSysprop = "otel.app.customlogmanager";
        String customLogManagerProp = System.getProperty(tracerCustomLogManSysprop);
        String customLogManagerEnv = System.getenv(tracerCustomLogManSysprop.replace('.', '_').toUpperCase());
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            log.debug("Prop - customlogmanager: " + customLogManagerProp);
            log.debug("Env - customlogmanager: " + customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        String jbossHome = System.getenv("JBOSS_HOME");
        if (jbossHome != null) {
            log.debug("Env - jboss: " + jbossHome);
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(logManagerProp.replaceAll("\\.", "/") + ".class") != null;
            log.debug("Prop - logging.manager: " + logManagerProp);
            log.debug("logging.manager on system classpath: " + onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isJavaBefore9WithJfr() {
        if (!AgentInitializer.isJavaBefore9()) {
            return false;
        }
        String jfrClassResourceName = "jdk.jfr.Recording".replace('.', '/') + ".class";
        return Thread.currentThread().getContextClassLoader().getResource(jfrClassResourceName) != null;
    }

    private static void logVersionInfo() {
        VersionLogger.logAllVersions();
        log.debug(AgentInstaller.class.getName() + " loaded on " + AgentInstaller.class.getClassLoader());
    }

    private AgentInstaller() {
    }

    static {
        CLASS_LOAD_CALLBACKS = new HashMap<String, List<Runnable>>();
        LoggingConfigurer.configureLogger();
        log = LoggerFactory.getLogger(AgentInstaller.class);
        AgentInstaller.addByteBuddyRawSetting();
        BootstrapPackagePrefixesHolder.setBoostrapPackagePrefixes(AgentInstaller.loadBootstrapPackagePrefixes());
        AgentTooling.registerWeakMapProvider();
        AgentTooling.registerBoundedCacheProvider();
        ConfigInitializer.initialize();
    }

    private static class NoopIgnoreMatcherProvider
    implements IgnoreMatcherProvider {
        private NoopIgnoreMatcherProvider() {
        }

        public IgnoreMatcherProvider.Result classloader(ClassLoader classLoader) {
            return IgnoreMatcherProvider.Result.DEFAULT;
        }

        public IgnoreMatcherProvider.Result type(TypeDescription target) {
            return IgnoreMatcherProvider.Result.DEFAULT;
        }
    }

    private static class RedefinitionDiscoveryStrategy
    implements AgentBuilder.RedefinitionStrategy.DiscoveryStrategy {
        private static final AgentBuilder.RedefinitionStrategy.DiscoveryStrategy delegate = AgentBuilder.RedefinitionStrategy.DiscoveryStrategy.Reiterating.INSTANCE;

        private RedefinitionDiscoveryStrategy() {
        }

        public Iterable<Iterable<Class<?>>> resolve(Instrumentation instrumentation) {
            return Iterables.transform((Iterable)delegate.resolve(instrumentation), i -> Iterables.filter((Iterable)i, c -> !RedefinitionDiscoveryStrategy.isIgnored(c)));
        }

        private static boolean isIgnored(Class<?> c) {
            ClassLoader cl = c.getClassLoader();
            if (cl != null && cl.getClass() == AgentClassLoader.class) {
                return true;
            }
            return HelperInjector.isInjectedClass(c);
        }
    }

    private static class ClassLoadListener
    implements AgentBuilder.Listener {
        private ClassLoadListener() {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b, DynamicType dynamicType) {
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, boolean b) {
        }

        public void onError(String s, ClassLoader classLoader, JavaModule javaModule, boolean b, Throwable throwable) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String typeName, ClassLoader classLoader, JavaModule javaModule, boolean b) {
            Map map = CLASS_LOAD_CALLBACKS;
            synchronized (map) {
                List callbacks = (List)CLASS_LOAD_CALLBACKS.get(typeName);
                if (callbacks != null) {
                    for (Runnable callback : callbacks) {
                        callback.run();
                    }
                }
            }
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        protected ClassLoadCallBack() {
        }

        @Override
        public void run() {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        this.execute();
                    }
                    catch (Exception e) {
                        log.error("Failed to run class loader callback {}", (Object)this.getName(), (Object)e);
                    }
                }
            });
            thread.setName("agent-startup-" + this.getName());
            thread.setDaemon(true);
            thread.start();
        }

        public abstract String getName();

        public abstract void execute();
    }

    protected static class InstallComponentAfterByteBuddyCallback
    extends ClassLoadCallBack {
        private final Iterable<ComponentInstaller> componentInstallers;

        protected InstallComponentAfterByteBuddyCallback(Iterable<ComponentInstaller> componentInstallers) {
            this.componentInstallers = componentInstallers;
        }

        @Override
        public String getName() {
            return this.componentInstallers.getClass().getName();
        }

        @Override
        public void execute() {
            for (ComponentInstaller componentInstaller : this.componentInstallers) {
                componentInstaller.afterByteBuddyAgent();
            }
        }
    }

    static class TransformLoggingListener
    implements AgentBuilder.Listener {
        private static final TransformSafeLogger log = TransformSafeLogger.getLogger(TransformLoggingListener.class);

        TransformLoggingListener() {
        }

        public void onError(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded, Throwable throwable) {
            if (log.isDebugEnabled()) {
                log.debug("Failed to handle {} for transformation on classloader {}: {}", typeName, classLoader, throwable.getMessage());
            }
        }

        public void onTransformation(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded, DynamicType dynamicType) {
            log.debug("Transformed {} -- {}", (Object)typeDescription.getName(), (Object)classLoader);
        }

        public void onIgnored(TypeDescription typeDescription, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onComplete(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }

        public void onDiscovery(String typeName, ClassLoader classLoader, JavaModule module, boolean loaded) {
        }
    }

    static class RedefinitionLoggingListener
    implements AgentBuilder.RedefinitionStrategy.Listener {
        private static final Logger log = LoggerFactory.getLogger(RedefinitionLoggingListener.class);

        RedefinitionLoggingListener() {
        }

        public void onBatch(int index, List<Class<?>> batch, List<Class<?>> types) {
        }

        public Iterable<? extends List<Class<?>>> onError(int index, List<Class<?>> batch, Throwable throwable, List<Class<?>> types) {
            if (log.isDebugEnabled()) {
                log.debug("Exception while retransforming " + batch.size() + " classes: " + batch, throwable);
            }
            return Collections.emptyList();
        }

        public void onComplete(int amount, List<Class<?>> types, Map<List<Class<?>>, Throwable> failures) {
        }
    }
}

