/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.bytebuddy.matcher;

import java.util.Objects;
import net.bytebuddy.matcher.ElementMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LoggingFailSafeMatcher<T>
extends ElementMatcher.Junction.AbstractBase<T> {
    private static final Logger log = LoggerFactory.getLogger(LoggingFailSafeMatcher.class);
    private final ElementMatcher<? super T> matcher;
    private final boolean fallback;
    private final String description;

    public LoggingFailSafeMatcher(ElementMatcher<? super T> matcher, boolean fallback, String description) {
        this.matcher = matcher;
        this.fallback = fallback;
        this.description = description;
    }

    public boolean matches(T target) {
        try {
            return this.matcher.matches(target);
        }
        catch (Exception e) {
            log.debug(this.description, (Throwable)e);
            return this.fallback;
        }
    }

    public String toString() {
        return "failSafe(try(" + this.matcher + ") or " + this.fallback + ")";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LoggingFailSafeMatcher)) {
            return false;
        }
        LoggingFailSafeMatcher other = (LoggingFailSafeMatcher)((Object)obj);
        return this.fallback == other.fallback && this.matcher.equals(other.matcher);
    }

    public int hashCode() {
        return Objects.hash(this.fallback, this.matcher);
    }
}

