/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.field;

import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.bootstrap.field.VirtualFieldInstalledMarker;
import java.util.Collection;

public final class VirtualFieldDetector {
    private static final Cache<Class<?>, Collection<String>> classesWithVirtualFields = Cache.weak();

    private VirtualFieldDetector() {
    }

    public static boolean hasVirtualField(Class<?> clazz, String virtualFieldInterfaceClassName) {
        Class<?>[] interfaces;
        if (!VirtualFieldInstalledMarker.class.isAssignableFrom(clazz)) {
            return false;
        }
        for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
            if (!virtualFieldInterfaceClassName.equals(interfaceClass.getName())) continue;
            return true;
        }
        Collection virtualFields = (Collection)classesWithVirtualFields.get(clazz);
        return virtualFields != null && virtualFields.contains(virtualFieldInterfaceClassName);
    }

    public static void markVirtualFields(Class<?> clazz, Collection<String> virtualFieldClassName) {
        classesWithVirtualFields.put(clazz, virtualFieldClassName);
    }
}

