/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ExceptionLogger {
    private static final Logger logger = Logger.getLogger(ExceptionLogger.class.getName());
    private static final AtomicInteger counter = new AtomicInteger();

    public static void logSuppressedError(String message, Throwable error) {
        logger.log(Level.FINE, message, error);
        counter.incrementAndGet();
    }

    public static int getAndReset() {
        return counter.getAndSet(0);
    }

    private ExceptionLogger() {
    }
}

